/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util;

import java.io.UnsupportedEncodingException;

public final class StringUtil {
    public static String filterHTML(String input) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return input;
        }
        input = input.trim();
        input = input.replaceAll("<", "&lt;");
        input = input.replaceAll(">", "&gt;");
        input = input.replaceAll("'", "&#39;");
        return input;
    }

    public static String compileHtml(String input) {
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return input;
        }
        input = input.replaceAll("&amp;", "&");
        input = input.replaceAll("&lt;", "<");
        input = input.replaceAll("&gt;", ">");
        input = input.replaceAll("&nbsp;", " ");
        input = input.replaceAll("&#39;", "'");
        input = input.replaceAll("&quot;", "\"");
        return input.replaceAll("<br>", "\n");
    }

    public static int parseInt(String num) {
        return StringUtil.parseInt(num, 0);
    }

    public static int parseInt(Object num) {
        if (num == null) {
            return 0;
        }
        return StringUtil.parseInt(num.toString(), 0);
    }

    public static int parseInt(Object obj, int default_) {
        return StringUtil.parseInt(StringUtil.convertNULL(obj), default_);
    }

    public static int parseInt(String num, int default_) {
        if (num == null || num.length() == 0) {
            return default_;
        }
        try {
            return Integer.parseInt(num);
        }
        catch (NumberFormatException numberFormatException) {
            return default_;
        }
    }

    public static long parseLong(String num) {
        if (num == null) {
            return 0L;
        }
        try {
            return Long.parseLong(num);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    public static float parseFloat(String num) {
        if (num == null) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(num);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0f;
        }
    }

    public static double parseDouble(String num) {
        if (num == null) {
            return 0.0;
        }
        try {
            return Double.parseDouble(num);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }

    public static String getUTF8(String str) {
        if (str == null) {
            return "";
        }
        try {
            return new String(str.getBytes("ISO-8859-1"), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String convertNULL(String input) {
        if (input == null) {
            return "";
        }
        return input.trim().intern();
    }

    public static String convertNULL(Object input) {
        if (input == null) {
            return "";
        }
        return StringUtil.convertNULL(input.toString());
    }
}

