/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.cache;

import cn.jiangzeyin.cache.CacheConfigWildcardField;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RedisCacheConfig {
    private static final ConcurrentHashMap<Integer, Map<String, Long>> CACHE_INFO_CONCURRENT_HASH_MAP = new ConcurrentHashMap();
    private static Map<Integer, Long> defaultExpireTime;
    private static int defaultDatabase;
    private static DataSource dataSource;
    private static ConvertKey convertKey;

    public static void config(Class cls, int database, ConvertKey convertKey, DataSource source) throws IllegalAccessException {
        if (database < 0) {
            throw new IllegalArgumentException("database error");
        }
        defaultDatabase = database;
        RedisCacheConfig.config(cls, convertKey, source);
    }

    public static void config(Class cls, ConvertKey key, DataSource source) throws IllegalAccessException {
        dataSource = source;
        convertKey = key;
        RedisCacheConfig.loadClass(cls);
    }

    public static Map<String, Long> getExpires(int database) {
        return CACHE_INFO_CONCURRENT_HASH_MAP.get(database);
    }

    public static Long getGroupExpires(int database, String group) {
        Map<String, Long> map = CACHE_INFO_CONCURRENT_HASH_MAP.get(database);
        if (map == null) {
            return null;
        }
        return map.get(group);
    }

    public static Long getDefaultExpireTime(int database) {
        if (defaultExpireTime == null) {
            return 600L;
        }
        Long time = defaultExpireTime.get(database);
        if (time == null) {
            return 600L;
        }
        return time;
    }

    public static DataSource getDataSource() {
        return dataSource;
    }

    public static int getDefaultDatabase() {
        return defaultDatabase;
    }

    private static void loadClass(Class cls) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = cls.getFields()) {
            Class<?> type = field.getType();
            if (type == String.class) {
                CacheConfigWildcardField wildcardField;
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || (wildcardField = field.getAnnotation(CacheConfigWildcardField.class)) == null) continue;
                String key = (String)field.get(null);
                Map map = CACHE_INFO_CONCURRENT_HASH_MAP.computeIfAbsent(wildcardField.value(), k -> new HashMap());
                long cacheTime = wildcardField.UNIT().toSeconds(wildcardField.time());
                map.put(key, cacheTime);
                continue;
            }
            if (type != Map.class) continue;
            Map map = (Map)field.get(null);
            if (defaultExpireTime == null) {
                defaultExpireTime = map;
                continue;
            }
            defaultExpireTime.putAll(map);
        }
    }

    public static String getKeyGroup(String key, int database) {
        if (convertKey == null) {
            return "default";
        }
        return convertKey.getGroup(key, database);
    }

    static {
        defaultDatabase = -1;
    }

    public static interface DataSource {
        public Object get(String var1, int var2);
    }

    public static interface ConvertKey {
        public String getGroup(String var1, int var2);
    }
}

