/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.run.write;

import cn.jiangzeyin.database.base.WriteBase;
import cn.jiangzeyin.database.config.DatabaseContextHolder;
import cn.jiangzeyin.database.event.UpdateEvent;
import cn.jiangzeyin.database.util.SqlAndParameters;
import cn.jiangzeyin.database.util.SqlUtil;
import cn.jiangzeyin.system.SystemDbLog;
import cn.jiangzeyin.system.SystemExecutorService;
import cn.jiangzeyin.util.EntityInfo;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import com.mysql.jdbc.exceptions.jdbc4.MySQLIntegrityConstraintViolationException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;

public class Update<T>
extends WriteBase<T> {
    private String where;
    private List<Object> whereParameters;
    private Object keyValue;
    private String keyColumn;
    private HashMap<String, Object> update;
    private UpdateEvent event;

    public UpdateEvent getEvent() {
        return this.event;
    }

    public void setEvent(UpdateEvent event) {
        this.event = event;
    }

    public Update(T data) {
        super(data);
    }

    public Update(T data, UpdateEvent event) {
        super(data);
        this.event = event;
    }

    public Update(T data, boolean isThrows) {
        super(data);
        this.setThrows(isThrows);
    }

    public Update() {
        super(null);
    }

    public Update(boolean isThrows) {
        super(null);
        this.setThrows(isThrows);
    }

    public HashMap<String, Object> getUpdate() {
        return this.update;
    }

    public void setUpdate(HashMap<String, Object> update) {
        this.update = update;
    }

    public void putUpdate(String column, Object value) {
        if (SqlUtil.isNotWriteColumn(column)) {
            return;
        }
        if (this.update == null) {
            this.update = new HashMap();
        }
        this.update.put(column, value);
    }

    public Object getKeyValue() {
        return this.keyValue;
    }

    public void setKeyValue(Object keyValue) {
        this.keyValue = keyValue;
    }

    public String getKeyColumn() {
        if (StringUtils.isEmpty((CharSequence)this.keyColumn)) {
            return "id";
        }
        return this.keyColumn;
    }

    public void setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
    }

    @Override
    public List<String> getRemove() {
        this.setRemove("createTime", "isDelete", "id");
        return super.getRemove();
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public void AppendWhere(String where) {
        this.where = StringUtils.isEmpty((CharSequence)this.where) ? where : this.where + " and " + where;
    }

    public List<Object> getWhereParameters() {
        return this.whereParameters;
    }

    public void setWhereParameters(List<Object> whereParameters) {
        this.whereParameters = whereParameters;
    }

    public void setWhereParameters(Object ... whereParameters) {
        if (this.whereParameters == null) {
            this.whereParameters = new LinkedList<Object>();
        }
        Collections.addAll(this.whereParameters, whereParameters);
    }

    @Override
    public void run() {
        this.setAsync(true);
        this.setThrowable(new Throwable());
        SystemExecutorService.execute(() -> this.syncRun());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long syncRun() {
        try {
            Object data = this.getData();
            String tag = data == null ? EntityInfo.getDatabaseName(this.getTclass()) : EntityInfo.getDatabaseName(data);
            SqlAndParameters sqlAndParameters = SqlUtil.getUpdateSql(this);
            DataSource dataSource = DatabaseContextHolder.getWriteDataSource(tag);
            SystemDbLog.getInstance().info(sqlAndParameters.getSql());
            this.setRunSql(sqlAndParameters.getSql());
            int count = JdbcUtils.executeUpdate((DataSource)dataSource, (String)sqlAndParameters.getSql(), sqlAndParameters.getParameters());
            if (this.event != null) {
                this.event.completeU(this.getKeyValue());
            }
            long l = count;
            return l;
        }
        catch (MySQLIntegrityConstraintViolationException e) {
            SystemDbLog.getInstance().error(e.getLocalizedMessage() + "\u4e3b\u952e\u7ea6\u675f", e);
            if (this.event != null) {
                this.event.errorU(e);
            }
            long l = -1L;
            return l;
        }
        catch (Exception e) {
            this.isThrows(e);
            if (this.event != null) {
                this.event.errorU(e);
            }
        }
        finally {
            this.recycling();
            this.update = null;
            this.whereParameters = null;
            this.event = null;
            this.runEnd();
        }
        return 0L;
    }
}

