/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.util;

import cn.jiangzeyin.database.Page;
import cn.jiangzeyin.database.base.WriteBase;
import cn.jiangzeyin.database.config.ModifyUser;
import cn.jiangzeyin.database.run.read.Select;
import cn.jiangzeyin.database.run.read.SelectPage;
import cn.jiangzeyin.database.run.write.Insert;
import cn.jiangzeyin.database.run.write.Remove;
import cn.jiangzeyin.database.run.write.Update;
import cn.jiangzeyin.database.util.SqlAndParameters;
import cn.jiangzeyin.util.Assert;
import cn.jiangzeyin.util.EntityInfo;
import cn.jiangzeyin.util.StringUtil;
import cn.jiangzeyin.util.ref.ReflectCache;
import cn.jiangzeyin.util.ref.ReflectUtil;
import com.alibaba.druid.util.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SqlUtil {
    public static boolean isWrite(Field field) {
        if (field.getModifiers() == 25 || field.getModifiers() == 26) {
            return false;
        }
        return !field.getName().startsWith("_");
    }

    private static SqlAndParameters getWriteSql(WriteBase<?> write, Object data) throws IllegalArgumentException, IllegalAccessException {
        if (data == null) {
            data = write.getData();
        }
        Assert.notNull(data, String.format("%s", write.getTclass(false)));
        ArrayList<String> cloums = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        HashMap<String, String> systemMap = new HashMap<String, String>();
        List<String> remove = write.getRemove();
        HashMap<String, Class<?>> refMap = write.getRefMap();
        for (Class<?> calzz = data.getClass(); calzz != Object.class; calzz = calzz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = ReflectCache.getDeclaredFields(calzz)) {
                if (!SqlUtil.isWrite(field) || remove != null && remove.contains(field.getName().toLowerCase())) continue;
                cloums.add(field.getName());
                String value1 = SqlUtil.getSystemValue(field.getName());
                if (value1 == null) {
                    Object va = ReflectUtil.getFieldValue(data, field.getName());
                    if ("pwd".equalsIgnoreCase(field.getName())) {
                        systemMap.put(field.getName(), "PASSWORD(?)");
                        values.add(va);
                        continue;
                    }
                    if (refMap != null && refMap.containsKey(field.getName())) {
                        Object refData = ReflectUtil.getFieldValue(data, field.getName());
                        if (refData == null) {
                            throw new RuntimeException(field.getName() + " \u4e3anull");
                        }
                        va = ReflectUtil.getFieldValue(refData, write.getRefKey());
                    }
                    values.add(va);
                    continue;
                }
                systemMap.put(field.getName(), value1);
            }
        }
        SqlAndParameters sqlAndParameters = new SqlAndParameters();
        sqlAndParameters.setParameters(values);
        sqlAndParameters.setCloums(cloums);
        sqlAndParameters.setSystemMap(systemMap);
        return sqlAndParameters;
    }

    private static SqlAndParameters getWriteSql(WriteBase<?> write) throws IllegalArgumentException, IllegalAccessException {
        return SqlUtil.getWriteSql(write, null);
    }

    public static SqlAndParameters getInsertSql(WriteBase<?> insert) throws IllegalArgumentException, IllegalAccessException {
        SqlAndParameters sqlAndParameters = SqlUtil.getWriteSql(insert);
        Object isDeleteField = ReflectUtil.getFieldValue(insert.getData(), "isDelete");
        int isDelete = isDeleteField == null ? 0 : Integer.parseInt(isDeleteField.toString());
        sqlAndParameters.setSql(SqlUtil.makeInsertToTableSql(insert.getData().getClass(), insert.getOptUserId(), sqlAndParameters.getCloums(), sqlAndParameters.getSystemMap(), isDelete));
        return sqlAndParameters;
    }

    public static SqlAndParameters[] getInsertSql(Insert<?> insert) throws IllegalArgumentException, IllegalAccessException {
        List<?> list = insert.getList();
        SqlAndParameters[] andParameters = new SqlAndParameters[list.size()];
        for (int i = 0; i < andParameters.length; ++i) {
            Object object = list.get(i);
            if (object == null) continue;
            SqlAndParameters sqlAndParameters = SqlUtil.getWriteSql(insert, object);
            Object isDeleteF = ReflectUtil.getFieldValue(object, "isDelete");
            int isDelete = isDeleteF == null ? 0 : Integer.parseInt(isDeleteF.toString());
            sqlAndParameters.setSql(SqlUtil.makeInsertToTableSql(object.getClass(), insert.getOptUserId(), sqlAndParameters.getCloums(), sqlAndParameters.getSystemMap(), isDelete));
            andParameters[i] = sqlAndParameters;
        }
        return andParameters;
    }

    public static SqlAndParameters getUpdateSql(Update<?> update) throws IllegalArgumentException, IllegalAccessException {
        StringBuffer sbSql;
        String sql;
        SqlAndParameters sqlAndParameters = null;
        if (update.getUpdate() != null) {
            sqlAndParameters = new SqlAndParameters();
            sql = SqlUtil.makeUpdateToTableSql(SqlUtil.getTableName(update.getTclass(), false), update.getUpdate());
            sbSql = new StringBuffer(sql);
        } else {
            sqlAndParameters = SqlUtil.getWriteSql(update);
            sql = SqlUtil.makeUpdateToTableSql(SqlUtil.getTableName(update.getData().getClass(), false), sqlAndParameters.getCloums(), sqlAndParameters.getSystemMap());
            sbSql = new StringBuffer(sql);
        }
        if (update.getOptUserId() != -1) {
            Class<?> class1 = update.getTclass(false);
            if (class1 == null) {
                class1 = update.getData().getClass();
            }
            if (ModifyUser.Modify.isModifyClass(class1)) {
                sbSql.append(",").append(ModifyUser.Modify.getColumnUser()).append("=").append(update.getOptUserId());
                sbSql.append(",").append(ModifyUser.Modify.getColumnTime()).append("=").append(ModifyUser.Modify.getModifyTime()).append("");
            }
        }
        boolean isAppendWhere = false;
        boolean isWhere = false;
        if (!StringUtils.isEmpty((CharSequence)StringUtil.convertNULL(update.getKeyValue()))) {
            sbSql.append(" where ");
            sbSql.append(update.getKeyColumn());
            sbSql.append("=").append("'").append(update.getKeyValue()).append("'");
            isAppendWhere = true;
            isWhere = true;
        }
        if (!StringUtils.isEmpty((CharSequence)update.getWhere())) {
            sbSql.append(isAppendWhere ? " and " : " where ");
            sbSql.append(update.getWhere());
            isWhere = true;
        }
        if (!isWhere) {
            if (update.getData() != null) {
                Object objId = ReflectUtil.getFieldValue(update.getData(), "id");
                Assert.notNull(objId, "\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u66f4\u65b0\u6761\u4ef6");
                sbSql.append(" where id=");
                sbSql.append(Long.parseLong(objId.toString()));
            } else {
                sbSql.append(" where ").append(update.getKeyColumn()).append("=").append(update.getKeyValue());
            }
        }
        sqlAndParameters.setSql(sbSql);
        List<Object> parameters = null;
        if (update.getUpdate() == null) {
            parameters = sqlAndParameters.getParameters();
        } else {
            LinkedList<Object> paList = new LinkedList<Object>();
            Collections.addAll(paList, update.getUpdate().values().toArray());
            parameters = paList;
        }
        if (parameters == null) {
            parameters = update.getWhereParameters();
        } else if (update.getWhereParameters() != null) {
            parameters.addAll(update.getWhereParameters());
        }
        sqlAndParameters.setParameters(parameters);
        return sqlAndParameters;
    }

    public static String[] getSelectPageSql(SelectPage<?> select) {
        StringBuffer sql = new StringBuffer("select ");
        sql.append(select.getColumns()).append(" from ").append(SqlUtil.getTableName(select.getTclass(), true, select.getIndex(), false)).append(" ");
        String[] countsql = new String[2];
        countsql[0] = SqlUtil.getCountSql(sql.toString(), select.getPage());
        SqlUtil.getMysqlPageSql(select.getPage(), sql);
        countsql[1] = sql.toString();
        return countsql;
    }

    public static String[] getSelectPageSql(Page<?> page) {
        StringBuffer sql = new StringBuffer(page.getSql());
        String[] countsql = new String[2];
        countsql[0] = SqlUtil.getCountSql(sql.toString(), page);
        SqlUtil.getMysqlPageSql(page, sql);
        countsql[1] = sql.toString();
        return countsql;
    }

    public static String getRefSql(Class<?> ref, String keyColumn, String where) {
        StringBuilder sql = new StringBuilder("select ").append(" * from ").append(SqlUtil.getTableName(ref)).append(" where ").append(keyColumn).append("=?");
        if (!StringUtils.isEmpty((CharSequence)where)) {
            sql.append(" and ").append(where);
        }
        return sql.toString();
    }

    public static String getIsexistsSql(Class<?> clas, String keyColumn, String where, String column, int limit) {
        StringBuilder sql = new StringBuilder("select ");
        if (StringUtils.isEmpty((CharSequence)column)) {
            sql.append(" count(1) as countSum from ");
        } else {
            sql.append(" ").append(column).append(" from ");
        }
        sql.append(SqlUtil.getTableName(clas)).append(" where ").append(keyColumn).append("=?");
        if (!StringUtils.isEmpty((CharSequence)where)) {
            String tempWhere = where.toLowerCase().trim();
            sql.append(tempWhere.startsWith("or") ? "" : " and ").append(where);
        }
        if (limit <= 0) {
            limit = 1;
        }
        sql.append(" limit ").append(limit);
        return sql.toString();
    }

    public static String getRemoveSql(Class<?> cls, Remove.Type type, String ids, String where) {
        StringBuilder sql = new StringBuilder();
        if (type == Remove.Type.delete) {
            sql.append("delete from ").append(SqlUtil.getTableName(cls, false));
        } else {
            int status = type == Remove.Type.remove ? 1 : 0;
            sql.append("update ").append(SqlUtil.getTableName(cls, false)).append(String.format(" set isDelete=%d,modifyTime=UNIX_TIMESTAMP(NOW())", status));
        }
        boolean iswhere = false;
        if (!StringUtils.isEmpty((CharSequence)ids)) {
            sql.append(" where id in(").append(ids).append(")");
            iswhere = true;
        }
        if (!StringUtils.isEmpty((CharSequence)where)) {
            sql.append(iswhere ? " and " : " where ").append(where);
        }
        return sql.toString();
    }

    public static String getSelectSql(Select<?> select) throws IllegalArgumentException, IllegalAccessException {
        StringBuilder sql = new StringBuilder("select ");
        sql.append(select.getColumns()).append(" from ").append(SqlUtil.getTableName(select.getTclass(), true, select.getIndex(), false)).append(" ");
        boolean isWhere = false;
        if (!StringUtils.isEmpty((CharSequence)StringUtil.convertNULL(select.getKeyValue()))) {
            isWhere = true;
            sql.append("where ").append(select.getKeyColumn()).append("=").append("'").append(select.getKeyValue()).append("'");
        }
        if (!StringUtils.isEmpty((CharSequence)select.getWhere())) {
            sql.append(isWhere ? " and " : " where ").append(select.getWhere());
            if (!isWhere) {
                isWhere = true;
            }
        }
        if (select.getIsDelete() != -1) {
            sql.append(isWhere ? " and " : " where ").append("isDelete=").append(select.getIsDelete());
        }
        if (!StringUtils.isEmpty((CharSequence)select.getOrderBy())) {
            sql.append(" order by ").append(select.getOrderBy());
        }
        if (select.getLimitStart() == 0 && select.getLimitCount() != 0) {
            sql.append(" limit ").append(select.getLimitCount());
        } else if (select.getLimitStart() > 0) {
            sql.append(" limit ").append(select.getLimitStart()).append(",").append(select.getLimitCount());
        }
        return sql.toString();
    }

    public static String getMysqlPageSql(Page<?> page, StringBuffer sqlBuffer) {
        long offset = (page.getPageNo() - 1L) * page.getPageSize();
        SqlUtil.doWhere(sqlBuffer, page);
        if (page.getOrderBy() != null && !"".equals(page.getOrderBy())) {
            sqlBuffer.append(" order by ").append(page.getOrderBy());
        }
        sqlBuffer.append(" limit ").append(offset).append(",").append(page.getPageSize());
        return sqlBuffer.toString();
    }

    private static void doWhere(StringBuffer sqlBuffer, Page page) {
        if (!StringUtils.isEmpty((CharSequence)page.getWhereWord())) {
            if (sqlBuffer.indexOf("where") == -1) {
                sqlBuffer.append(" where ");
            } else {
                sqlBuffer.append(" and ");
            }
            sqlBuffer.append(page.getWhereWord());
        }
    }

    public static String getCountSql(String sql, Page<?> page) {
        StringBuffer sqlBuffer = new StringBuffer(sql);
        SqlUtil.doWhere(sqlBuffer, page);
        return "select count(1)  as count from (" + sqlBuffer + ") as total";
    }

    private static String getSystemValue(String name) {
        if ("modifyTime".equalsIgnoreCase(name)) {
            return "UNIX_TIMESTAMP(NOW())";
        }
        if ("isDelete".equalsIgnoreCase(name)) {
            return "0";
        }
        if ("createTime".equalsIgnoreCase(name)) {
            return "UNIX_TIMESTAMP(NOW())";
        }
        return null;
    }

    public static boolean isNotWriteColumn(String name) {
        if ("modifyTime".equalsIgnoreCase(name)) {
            return true;
        }
        if ("isDelete".equalsIgnoreCase(name)) {
            return true;
        }
        if ("createTime".equalsIgnoreCase(name)) {
            return true;
        }
        if ("createUser".equalsIgnoreCase(name)) {
            return true;
        }
        if ("lastModifyUser".equalsIgnoreCase(name)) {
            return true;
        }
        return "lastModifyTime".equalsIgnoreCase(name);
    }

    public static String getTableName(Class<?> class1) {
        return SqlUtil.getTableName(class1, true, null, false);
    }

    public static String getTableName(Class<?> class1, String index) {
        return SqlUtil.getTableName(class1, true, index, false);
    }

    public static String getTableName(Class<?> class1, String index, boolean isDatabaseName) {
        return SqlUtil.getTableName(class1, true, index, isDatabaseName);
    }

    public static String getTableName(Class<?> class1, boolean isIndex) {
        return SqlUtil.getTableName(class1, isIndex, null, false);
    }

    public static String getTableName(Class<?> class1, boolean isIndex, String index, boolean isDatabaName) {
        String name = class1.getSimpleName();
        if (name.endsWith("_")) {
            name = name.substring(0, name.lastIndexOf("_"));
        }
        if (isIndex) {
            name = !StringUtils.isEmpty((CharSequence)index) ? (isDatabaName ? String.format("z_%s.%s force index(%s)", EntityInfo.getDatabaseName(class1), name, index) : String.format("%s force index(%s)", name, index)) : (isDatabaName ? String.format("z_%s.%s force index(PRIMARY)", EntityInfo.getDatabaseName(class1), name) : String.format("%s force index(PRIMARY)", name));
        } else if (isDatabaName) {
            name = String.format("z_%s.%s", EntityInfo.getDatabaseName(class1), name);
        }
        return name;
    }

    public static String function(String functionName, List<Object> parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append(functionName).append("(");
        if (parameters != null && parameters.size() > 0) {
            for (int i = 0; i < parameters.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("?");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private static String makeInsertToTableSql(Class<?> class1, int createUser, Collection<String> names, HashMap<String, String> systemMap, int isDeleteValue) {
        String tableName = SqlUtil.getTableName(class1, false);
        StringBuilder sql = new StringBuilder().append("insert into ").append(tableName).append("(");
        int nameCount = 0;
        StringBuilder value = new StringBuilder();
        boolean isDelete = false;
        for (String name : names) {
            if (nameCount > 0) {
                sql.append(",");
            }
            sql.append(name);
            String va = systemMap.get(name);
            if (nameCount > 0) {
                value.append(",");
            }
            if (va == null) {
                value.append("?");
            } else if ("isDelete".equals(name)) {
                value.append(isDeleteValue);
                isDelete = true;
            } else {
                value.append(va);
            }
            ++nameCount;
        }
        if (createUser != -1 && ModifyUser.Create.isCreateClass(class1)) {
            sql.append(",").append(ModifyUser.Create.getColumnUser());
            value.append(",").append(createUser);
        }
        if (!isDelete) {
            sql.append(",isDelete");
            value.append(",").append(isDeleteValue);
        }
        sql.append(") values (");
        sql.append((CharSequence)value);
        sql.append(")");
        return sql.toString();
    }

    public static String makeUpdateToTableSql(String tableName, Collection<String> names, HashMap<String, String> systemMap) {
        StringBuilder sql = new StringBuilder().append("update ").append(tableName).append(" set ");
        int nameCount = 0;
        for (String name : names) {
            if (nameCount > 0) {
                sql.append(",");
            }
            sql.append(name);
            sql.append("=");
            String va = systemMap.get(name);
            if (va == null) {
                sql.append("?");
            } else {
                sql.append(va);
            }
            ++nameCount;
        }
        if (sql.indexOf("modifyTime=UNIX_TIMESTAMP(NOW())") == -1) {
            sql.append(",modifyTime=UNIX_TIMESTAMP(NOW())");
        }
        return sql.toString();
    }

    public static String makeUpdateToTableSql(String tableName, HashMap<String, Object> columns) {
        StringBuilder sql = new StringBuilder().append("update ").append(tableName).append(" set ");
        int nameCount = 0;
        Iterator<Map.Entry<String, Object>> iterator = columns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String name = entry.getKey();
            Object obj_value = entry.getValue();
            if (nameCount > 0) {
                sql.append(",");
            }
            sql.append(name);
            sql.append("=");
            String va = SqlUtil.getSystemValue(name);
            if (va == null) {
                if ("pwd".equalsIgnoreCase(name)) {
                    sql.append("PASSWORD(?)");
                } else {
                    String value = StringUtil.convertNULL(obj_value);
                    if (value.startsWith("#{") && value.endsWith("}")) {
                        value = value.substring(value.indexOf("#{") + 2, value.indexOf("}"));
                        sql.append(value);
                        iterator.remove();
                    } else {
                        sql.append("?");
                    }
                }
            } else {
                sql.append(va);
            }
            ++nameCount;
        }
        sql.append(",modifyTime=UNIX_TIMESTAMP(NOW())");
        return sql.toString();
    }
}

