/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util.ref;

import cn.jiangzeyin.util.Assert;
import cn.jiangzeyin.util.ref.ReflectCache;
import com.alibaba.druid.util.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ReflectUtil {
    public static Object getFieldValue(Object obj, String fieldName) throws IllegalArgumentException, IllegalAccessException {
        Assert.notNull(obj);
        Object result = null;
        Field field = ReflectUtil.getField(obj.getClass(), fieldName);
        if (field != null) {
            field.setAccessible(true);
            result = field.get(obj);
        }
        return result;
    }

    public static boolean isSuperclass(Class class1, Class class2) {
        for (Class calzz = class1; calzz != Object.class; calzz = calzz.getSuperclass()) {
            if (calzz != class2) continue;
            return true;
        }
        return false;
    }

    public static Annotation getFieldAnnotation(Class<?> cls, String name, Class<? extends Annotation> annotationClass) throws IllegalArgumentException, IllegalAccessException {
        Field field = ReflectUtil.getField(cls, name);
        if (field == null) {
            return null;
        }
        return field.getAnnotation(annotationClass);
    }

    public static Annotation getFieldAnnotation(Class<?> cls, Class<? extends Annotation> annotationClass) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields = ReflectCache.getDeclaredFields(cls);
        if (fields == null) {
            return null;
        }
        for (Field field : fields) {
            Annotation annotation = field.getAnnotation(annotationClass);
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    public static List<String> getAnnotationFieldNames(Class<?> cls, Class<? extends Annotation> annotationClass) throws IllegalArgumentException, IllegalAccessException {
        Field[] fields = ReflectCache.getDeclaredFields(cls);
        if (fields == null) {
            return null;
        }
        ArrayList<String> fields2 = new ArrayList<String>();
        for (Field field : fields) {
            Annotation annotation = field.getAnnotation(annotationClass);
            if (annotation == null) continue;
            fields2.add(field.getName());
        }
        return fields2;
    }

    public static Object getMethodValue(Object obj, String fieldName) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        fieldName = ReflectUtil.captureName(fieldName);
        Method method = ReflectUtil.getMethod(obj.getClass(), "get" + fieldName, new Class[0]);
        if (method == null) {
            throw new IllegalArgumentException(String.format("\u6ca1\u6709\u627e\u5230%s \u5bf9\u5e94get \u65b9\u6cd5", fieldName));
        }
        return method.invoke(obj, new Object[0]);
    }

    public static String captureName(String inString) {
        if (StringUtils.isEmpty((CharSequence)inString)) {
            return "";
        }
        if (inString.length() > 1) {
            return inString.substring(0, 1).toUpperCase() + inString.substring(1);
        }
        return inString.toUpperCase();
    }

    public static Field getField(Class<?> cls, String fieldName) {
        Field field = null;
        for (Class<?> clazz = cls; clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = ReflectCache.getDeclaredField(clazz, fieldName);
                break;
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        return field;
    }

    public static Method getMethod(Class<?> cls, String methodName, Class<?> ... parameterTypes) {
        Method method = null;
        for (Class<?> clazz = cls; clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                method = ReflectCache.getDeclaredMethod(clazz, methodName, parameterTypes);
                break;
            }
            catch (Exception e) {
                continue;
            }
        }
        return method;
    }

    public static void setFieldValue(Object obj, String fieldName, Object fieldValue) throws IllegalAccessException {
        Field field = ReflectUtil.getField(obj.getClass(), fieldName);
        if (field != null) {
            field.setAccessible(true);
            Class<?> type = field.getType();
            String typeName = type.getSimpleName();
            if (type == Integer.TYPE) {
                field.set(obj, Integer.parseInt(fieldValue.toString()));
            } else if (type == Double.TYPE) {
                field.set(obj, Double.parseDouble(fieldValue.toString()));
            } else if (type == String.class) {
                if (fieldValue == null) {
                    field.set(obj, "");
                } else {
                    field.set(obj, fieldValue.toString());
                }
            } else if (type == Long.TYPE) {
                field.set(obj, Long.parseLong(fieldValue.toString()));
            } else if (type == Integer.class) {
                field.set(obj, Integer.valueOf(fieldValue.toString()));
            } else {
                field.set(obj, fieldValue);
            }
        }
    }

    public static Class<?> getTClass(Object obj) {
        Assert.notNull(obj, "obj \u4e0d\u80fd\u4e3a\u7a7a");
        return ReflectUtil.getTClass(obj.getClass());
    }

    public static Class<?> getTClass(Class<?> cls) {
        Type type = cls.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getActualTypeArguments()[0];
            return (Class)type;
        }
        return null;
    }

    public static List<Method> getAllGetMethods(Class cls) {
        return ReflectUtil.getAllMethods(cls, "get");
    }

    public static List<Method> getAllSetMethods(Class cls) {
        return ReflectUtil.getAllMethods(cls, "set");
    }

    private static List<Method> getAllMethods(Class cls, String prefix) {
        Assert.notNull(cls);
        ArrayList<Method> list = new ArrayList<Method>();
        for (Class clazz = cls; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!method.getName().startsWith(prefix)) continue;
                list.add(method);
            }
        }
        return list;
    }
}

