/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.run.write;

import cn.jiangzeyin.database.DbWriteService;
import cn.jiangzeyin.database.base.Base;
import cn.jiangzeyin.database.base.WriteBase;
import cn.jiangzeyin.database.config.DatabaseContextHolder;
import cn.jiangzeyin.database.config.SystemColumn;
import cn.jiangzeyin.database.util.SqlUtil;
import cn.jiangzeyin.system.DBExecutorService;
import cn.jiangzeyin.system.DbLog;
import com.alibaba.druid.util.JdbcUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;

public class Remove<T>
extends Base<T> {
    private WriteBase.Callback callback;
    private String ids;
    private String where;
    private List<Object> parameters;
    private Type type;
    private HashMap<String, Object> update;

    public HashMap<String, Object> getUpdate() {
        return this.update;
    }

    public void setUpdate(HashMap<String, Object> update) {
        if (this.type != Type.recovery) {
            throw new IllegalArgumentException("type must " + (Object)((Object)Type.recovery));
        }
        this.update = update;
    }

    public void putUpdate(String column, Object value) {
        if (this.type != Type.recovery) {
            throw new IllegalArgumentException("type must " + (Object)((Object)Type.recovery));
        }
        if (SystemColumn.notCanUpdate(column)) {
            throw new IllegalArgumentException(column + " not update");
        }
        if (this.update == null) {
            this.update = new HashMap();
        }
        this.update.put(column, value);
    }

    public void setCallback(WriteBase.Callback callback) {
        this.callback = callback;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Remove(Type type) {
        this(type, false);
    }

    public Remove(Type type, boolean isThrows) {
        this.type = type;
        this.setThrows(isThrows);
        if (-100 == SystemColumn.Active.getActiveValue() && type != Type.delete) {
            throw new IllegalArgumentException("plase set systemColumn.active");
        }
    }

    public List<Object> getParameters() {
        if (this.parameters == null) {
            return new ArrayList<Object>();
        }
        return this.parameters;
    }

    public void setParameters(List<Object> parameters) {
        this.parameters = parameters;
    }

    public void setParameters(Object ... parameters) {
        if (this.parameters == null) {
            this.parameters = new LinkedList<Object>();
        }
        Collections.addAll(this.parameters, parameters);
    }

    public String getIds() {
        return this.ids;
    }

    public void setIds(String ids) {
        this.ids = ids;
    }

    public void setIds(int id) {
        this.ids = String.valueOf(id);
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public void run() {
        this.getAsyncLog();
        DBExecutorService.execute(this::syncRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int syncRun() {
        if (this.type == null) {
            throw new IllegalArgumentException("type null");
        }
        try {
            String tag = DbWriteService.getDatabaseName(this.getTclass());
            String sql = SqlUtil.getRemoveSql(this);
            DbLog.getInstance().info(this.getTransferLog() + sql);
            this.setRunSql(sql);
            DataSource dataSource = DatabaseContextHolder.getWriteDataSource(tag);
            int up = JdbcUtils.executeUpdate((DataSource)dataSource, (String)sql, this.getParameters());
            if (up > 0 && this.callback != null) {
                this.callback.success(up);
            }
            int n = up;
            return n;
        }
        catch (Exception e) {
            this.isThrows(e);
        }
        finally {
            this.runEnd();
            this.recycling();
            this.parameters = null;
            this.ids = null;
            this.where = null;
        }
        return 0;
    }

    public static enum Type {
        delete,
        recovery,
        remove;

    }
}

