/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.config;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.system.SystemDbLog;
import cn.jiangzeyin.util.Assert;
import com.alibaba.druid.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ModifyUser {
    static void initCreate(Properties properties) {
        Assert.notNull(properties);
        String createClass = properties.getProperty("create.class");
        if (StringUtils.isEmpty((CharSequence)createClass)) {
            return;
        }
        String[] createClass_s = StringUtil.stringToArray((String)createClass);
        if (createClass_s == null || createClass_s.length < 1) {
            SystemDbLog.getInstance().warn("create.class is null");
        } else {
            for (String item : createClass_s) {
                try {
                    Create.create_class.add(Class.forName(item));
                }
                catch (ClassNotFoundException e) {
                    SystemDbLog.getInstance().error("load class", e);
                }
            }
            String column_user = properties.getProperty("create.column.user");
            if (StringUtils.isEmpty((CharSequence)column_user)) {
                SystemDbLog.getInstance().warn("lastModify.column.user is null");
            } else {
                Create.columnUser = column_user;
            }
        }
    }

    static void initModify(Properties properties) {
        Assert.notNull(properties);
        String modifyClass = properties.getProperty("lastModify.class");
        if (!StringUtils.isEmpty((CharSequence)modifyClass)) {
            String[] modifyClass_s = StringUtil.stringToArray((String)modifyClass);
            if (modifyClass_s == null || modifyClass_s.length < 1) {
                SystemDbLog.getInstance().warn("lastModify.class is null");
            } else {
                for (String item : modifyClass_s) {
                    try {
                        Modify.modify_class.add(Class.forName(item));
                    }
                    catch (ClassNotFoundException e) {
                        SystemDbLog.getInstance().error("load class", e);
                    }
                }
                String modify_time = properties.getProperty("lastModify.time");
                if (StringUtils.isEmpty((CharSequence)modify_time)) {
                    SystemDbLog.getInstance().warn("lastModify.time is null");
                } else {
                    Modify.modifyTime = modify_time;
                }
                String column_user = properties.getProperty("lastModify.column.user");
                if (StringUtils.isEmpty((CharSequence)column_user)) {
                    SystemDbLog.getInstance().warn("lastModify.column.user is null");
                } else {
                    Modify.columnUser = column_user;
                }
                String column_time = properties.getProperty("lastModify.column.time");
                if (StringUtils.isEmpty((CharSequence)column_time)) {
                    SystemDbLog.getInstance().warn("lastModify.column.time is null");
                } else {
                    Modify.columnTime = column_time;
                }
            }
        }
    }

    public static class Create {
        private static List<Class<?>> create_class = new ArrayList();
        private static String columnUser;

        public static String getColumnUser() {
            return columnUser;
        }

        public static boolean isCreateClass(Class tClass) {
            if (tClass == null) {
                return false;
            }
            for (Class<?> item : create_class) {
                if (!item.isAssignableFrom(tClass)) continue;
                return true;
            }
            return false;
        }
    }

    public static class Modify {
        private static List<Class<?>> modify_class = new ArrayList();
        private static String modifyTime;
        private static String columnUser;
        private static String columnTime;

        public static String getColumnTime() {
            return columnTime;
        }

        public static String getColumnUser() {
            return columnUser;
        }

        public static String getModifyTime() {
            return modifyTime;
        }

        public static boolean isModifyClass(Class tClass) {
            if (tClass == null) {
                return false;
            }
            for (Class<?> item : modify_class) {
                if (!item.isAssignableFrom(tClass)) continue;
                return true;
            }
            return false;
        }
    }
}

