/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.system;

import cn.jiangzeyin.system.SystemDbLog;
import cn.jiangzeyin.system.SystemThreadFactory;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;

public class SystemExecutorService {
    private static final ThreadPoolExecutor THREAD_POOL_EXECUTOR = SystemExecutorService.newCachedThreadPool();

    private static ThreadPoolExecutor newCachedThreadPool() {
        ThreadPoolExecutor executorService = (ThreadPoolExecutor)Executors.newCachedThreadPool();
        executorService.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        SystemThreadFactory systemThreadFactory = new SystemThreadFactory("sql_db");
        executorService.setThreadFactory(systemThreadFactory);
        return executorService;
    }

    public static void shutdown() {
        SystemDbLog.getInstance().info("\u5173\u95ed\u6570\u636e\u5e93\u4f7f\u7528\u7684\u7ebf\u7a0b\u6c60");
        THREAD_POOL_EXECUTOR.shutdown();
    }

    public static void execute(Runnable command) {
        THREAD_POOL_EXECUTOR.execute(command);
    }
}

