/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.run.read;

import cn.jiangzeyin.database.EntityInfo;
import cn.jiangzeyin.database.Page;
import cn.jiangzeyin.database.base.ReadBase;
import cn.jiangzeyin.database.config.DatabaseContextHolder;
import cn.jiangzeyin.database.util.SqlUtil;
import cn.jiangzeyin.database.util.Util;
import cn.jiangzeyin.system.SystemDbLog;
import cn.jiangzeyin.util.Assert;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class SelectPage<T>
extends ReadBase<T> {
    private Page<T> page;
    public static final int PageResultType = -2;

    public SelectPage(Page<T> page) {
        this.page = page;
    }

    public SelectPage(Page<T> page, int resultType) {
        this.page = page;
        this.setResultType(resultType);
    }

    public Page<T> getPage() {
        return this.page;
    }

    public void setPage(Page<T> page) {
        this.page = page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run() {
        Assert.notNull(this.page, "page");
        try {
            String tag = this.getTag();
            if (StringUtils.isEmpty((String)tag)) {
                tag = EntityInfo.getDatabaseName(this.getTclass());
                this.setTag(tag);
            }
            String[] pageSql = StringUtils.isEmpty((String)this.page.getSql()) ? SqlUtil.getSelectPageSql(this) : SqlUtil.getSelectPageSql(this.page);
            DataSource dataSource = DatabaseContextHolder.getReadDataSource(tag);
            List list = JdbcUtils.executeQuery((DataSource)dataSource, (String)pageSql[0], this.getParameters());
            if (list == null || list.size() < 1) {
                T t = null;
                return t;
            }
            Object count_map = (Map)list.get(0);
            if (count_map == null) {
                T t = null;
                return t;
            }
            long count = (Long)count_map.values().toArray()[0];
            this.page.setTotalRecord(count);
            this.setRunSql(pageSql[1]);
            SystemDbLog.getInstance().info(pageSql[1]);
            list = JdbcUtils.executeQuery((DataSource)dataSource, (String)pageSql[1], this.getParameters());
            this.page.setMapList(list);
            if (this.getResultType() == 1) {
                count_map = JSON.parseArray((String)JSON.toJSONString((Object)list));
                return (T)count_map;
            }
            if (this.getResultType() == 1) {
                if (list == null) {
                    count_map = null;
                    return (T)count_map;
                }
                count_map = JSONArray.toJSON((Object)list);
                return (T)count_map;
            }
            if (this.getResultType() == -2) {
                JSONObject data = new JSONObject();
                data.put("results", (Object)list);
                data.put("pageNo", (Object)this.page.getPageNo());
                data.put("pageSize", (Object)this.page.getPageSize());
                data.put("totalPage", (Object)this.page.getTotalPage());
                JSONObject jSONObject = data;
                return (T)jSONObject;
            }
            List result_list = Util.convertList(this, list);
            this.page.setResultsT(result_list);
            List list2 = result_list;
            return (T)list2;
        }
        catch (Exception e) {
            this.isThrows(e);
        }
        finally {
            this.recycling();
            this.runEnd();
        }
        return null;
    }
}

