/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.util;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.database.EntityInfo;
import cn.jiangzeyin.database.Page;
import cn.jiangzeyin.database.annotation.EntityConfig;
import cn.jiangzeyin.database.base.WriteBase;
import cn.jiangzeyin.database.config.ModifyUser;
import cn.jiangzeyin.database.config.SystemColumn;
import cn.jiangzeyin.database.run.read.Select;
import cn.jiangzeyin.database.run.read.SelectPage;
import cn.jiangzeyin.database.run.write.Insert;
import cn.jiangzeyin.database.run.write.Remove;
import cn.jiangzeyin.database.run.write.Update;
import cn.jiangzeyin.database.util.SqlAndParameters;
import cn.jiangzeyin.util.Assert;
import cn.jiangzeyin.util.ref.ReflectCache;
import cn.jiangzeyin.util.ref.ReflectUtil;
import com.alibaba.druid.util.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SqlUtil {
    private static boolean isWrite(Field field) {
        return field.getModifiers() != 25 && field.getModifiers() != 26 && !field.getName().startsWith("_");
    }

    private static SqlAndParameters getWriteSql(WriteBase<?> write, Object data) throws Exception {
        if (data == null) {
            data = write.getData();
        }
        Assert.notNull(data, String.format("%s", write.getTclass(false)));
        ArrayList<String> cloums = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        HashMap<String, String> systemMap = new HashMap<String, String>();
        List<String> remove = write.getRemove();
        HashMap<String, Class<?>> refMap = write.getRefMap();
        for (Class<?> calzz = data.getClass(); calzz != Object.class; calzz = calzz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = ReflectCache.getDeclaredFields(calzz)) {
                if (!SqlUtil.isWrite(field)) continue;
                String name = field.getName();
                if (remove != null && remove.contains(name.toLowerCase()) || SystemColumn.isWriteRemove(name)) continue;
                cloums.add(name);
                String value1 = SystemColumn.getDefaultValue(name);
                if (value1 == null) {
                    Object va = ReflectUtil.getFieldValue(data, name);
                    if (SystemColumn.getPwdColumn().equalsIgnoreCase(name)) {
                        systemMap.put(name, "PASSWORD(?)");
                        values.add(va);
                        continue;
                    }
                    if (refMap != null && refMap.containsKey(name.toLowerCase())) {
                        Object refData = ReflectUtil.getFieldValue(data, field.getName());
                        if (refData == null) {
                            throw new RuntimeException(name + " \u4e3anull");
                        }
                        va = ReflectUtil.getFieldValue(refData, write.getRefKey());
                    }
                    values.add(va);
                    continue;
                }
                systemMap.put(name, value1);
            }
        }
        SqlAndParameters sqlAndParameters = new SqlAndParameters();
        sqlAndParameters.setParameters(values);
        sqlAndParameters.setColumns(cloums);
        sqlAndParameters.setSystemMap(systemMap);
        return sqlAndParameters;
    }

    private static SqlAndParameters getWriteSql(WriteBase<?> write) throws Exception {
        return SqlUtil.getWriteSql(write, null);
    }

    public static SqlAndParameters getInsertSql(WriteBase<?> insert) throws Exception {
        EntityConfig entityConfig;
        SqlAndParameters sqlAndParameters = SqlUtil.getWriteSql(insert);
        int isDelete = -100;
        if (!StringUtils.isEmpty((String)SystemColumn.Active.getColumn()) && ((entityConfig = insert.getData().getClass().getAnnotation(EntityConfig.class)) == null || entityConfig.active())) {
            Object isDeleteF = ReflectUtil.getFieldValue(insert.getData(), SystemColumn.Active.getColumn());
            isDelete = isDeleteF == null ? SystemColumn.Active.getActiveValue() : Integer.parseInt(isDeleteF.toString());
        }
        sqlAndParameters.setSql(SqlUtil.makeInsertToTableSql(insert.getData().getClass(), insert.getOptUserId(), sqlAndParameters.getColumns(), sqlAndParameters.getSystemMap(), isDelete));
        return sqlAndParameters;
    }

    public static SqlAndParameters[] getInsertSql(Insert<?> insert) throws Exception {
        List<?> list = insert.getList();
        SqlAndParameters[] andParameters = new SqlAndParameters[list.size()];
        for (int i = 0; i < andParameters.length; ++i) {
            EntityConfig entityConfig;
            Object object = list.get(i);
            if (object == null) continue;
            SqlAndParameters sqlAndParameters = SqlUtil.getWriteSql(insert, object);
            int isDelete = -100;
            if (!StringUtils.isEmpty((String)SystemColumn.Active.getColumn()) && ((entityConfig = object.getClass().getAnnotation(EntityConfig.class)) == null || entityConfig.active())) {
                Object isDeleteF = ReflectUtil.getFieldValue(object, SystemColumn.Active.getColumn());
                isDelete = isDeleteF == null ? SystemColumn.Active.getActiveValue() : Integer.parseInt(isDeleteF.toString());
            }
            sqlAndParameters.setSql(SqlUtil.makeInsertToTableSql(object.getClass(), insert.getOptUserId(), sqlAndParameters.getColumns(), sqlAndParameters.getSystemMap(), isDelete));
            andParameters[i] = sqlAndParameters;
        }
        return andParameters;
    }

    public static SqlAndParameters getUpdateSql(Update<?> update) throws Exception {
        List<Object> parameters;
        StringBuffer sbSql;
        String sql;
        SqlAndParameters sqlAndParameters;
        Class<?> class1 = update.getTclass(false);
        if (class1 == null) {
            class1 = update.getData().getClass();
        }
        EntityConfig entityConfig = class1.getAnnotation(EntityConfig.class);
        boolean isLogUpdate = true;
        if (entityConfig != null && !entityConfig.update()) {
            isLogUpdate = false;
        }
        if (update.getUpdate() != null) {
            sqlAndParameters = new SqlAndParameters();
            sql = SqlUtil.makeUpdateToTableSql(SqlUtil.getTableName(update.getTclass(), false), update.getUpdate(), isLogUpdate);
            sbSql = new StringBuffer(sql);
        } else {
            sqlAndParameters = SqlUtil.getWriteSql(update);
            sql = SqlUtil.makeUpdateToTableSql(SqlUtil.getTableName(update.getData().getClass(), false), sqlAndParameters.getColumns(), sqlAndParameters.getSystemMap(), isLogUpdate);
            sbSql = new StringBuffer(sql);
        }
        if (update.getOptUserId() != -1 && ModifyUser.Modify.isModifyClass(class1)) {
            sbSql.append(",").append(ModifyUser.Modify.getColumnUser()).append("=").append(update.getOptUserId());
            sbSql.append(",").append(ModifyUser.Modify.getColumnTime()).append("=").append(ModifyUser.Modify.getModifyTime()).append("");
        }
        boolean isAppendWhere = false;
        boolean isWhere = false;
        if (!StringUtils.isEmpty((String)StringUtil.convertNULL((Object)update.getKeyValue()))) {
            sbSql.append(" where ");
            sbSql.append(update.getKeyColumn());
            sbSql.append("=").append("'").append(update.getKeyValue()).append("'");
            isAppendWhere = true;
            isWhere = true;
        }
        if (!StringUtils.isEmpty((String)update.getWhere())) {
            sbSql.append(isAppendWhere ? " and " : " where ");
            sbSql.append(update.getWhere());
            isWhere = true;
        }
        if (!isWhere) {
            if (update.getData() != null) {
                Object objId = ReflectUtil.getFieldValue(update.getData(), SystemColumn.getDefaultKeyName());
                Assert.notNull(objId, "\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u66f4\u65b0\u6761\u4ef6");
                sbSql.append(" where id=");
                sbSql.append(Long.parseLong(objId.toString()));
            } else {
                sbSql.append(" where ").append(update.getKeyColumn()).append("=").append(update.getKeyValue());
            }
        }
        sqlAndParameters.setSql(sbSql);
        if (update.getUpdate() == null) {
            parameters = sqlAndParameters.getParameters();
        } else {
            LinkedList<Object> paList = new LinkedList<Object>();
            Collections.addAll(paList, update.getUpdate().values().toArray());
            parameters = paList;
        }
        if (parameters == null) {
            parameters = update.getWhereParameters();
        } else if (update.getWhereParameters() != null) {
            parameters.addAll(update.getWhereParameters());
        }
        sqlAndParameters.setParameters(parameters);
        return sqlAndParameters;
    }

    public static String[] getSelectPageSql(SelectPage<?> select) {
        StringBuffer sql = new StringBuffer("select ");
        sql.append(select.getColumns()).append(" from ").append(SqlUtil.getTableName(select.getTclass(), true, select.getIndex(), false)).append(" ");
        String[] countSql = new String[]{SqlUtil.getCountSql(sql.toString(), select.getPage()), SqlUtil.getMysqlPageSql(select.getPage(), sql)};
        return countSql;
    }

    public static String[] getSelectPageSql(Page<?> page) {
        StringBuffer sql = new StringBuffer(page.getSql());
        String[] countSql = new String[]{SqlUtil.getCountSql(sql.toString(), page), SqlUtil.getMysqlPageSql(page, sql)};
        return countSql;
    }

    static String getRefSql(Class<?> ref, String keyColumn, String where) {
        StringBuilder sql = new StringBuilder("select ").append(" * from ").append(SqlUtil.getTableName(ref)).append(" where ").append(keyColumn).append("=?");
        if (!StringUtils.isEmpty((String)where)) {
            sql.append(" and ").append(where);
        }
        return sql.toString();
    }

    public static String getIsExistsSql(Class<?> clas, String keyColumn, String where, String column, int limit) {
        StringBuilder sql = new StringBuilder("select ");
        if (StringUtils.isEmpty((String)column)) {
            sql.append(" count(1) as countSum from ");
        } else {
            sql.append(" ").append(column).append(" from ");
        }
        sql.append(SqlUtil.getTableName(clas)).append(" where ").append(keyColumn).append("=?");
        if (!StringUtils.isEmpty((String)where)) {
            String tempWhere = where.toLowerCase().trim();
            sql.append(tempWhere.startsWith("or") ? "" : " and ").append(where);
        }
        if (limit <= 0) {
            limit = 1;
        }
        sql.append(" limit ").append(limit);
        return sql.toString();
    }

    public static String getRemoveSql(Class<?> cls, Remove.Type type, String ids, String where) {
        StringBuilder sql = new StringBuilder();
        if (type == Remove.Type.delete) {
            sql.append("delete from ").append(SqlUtil.getTableName(cls, false));
        } else {
            int status = type == Remove.Type.remove ? SystemColumn.Active.getInActiveValue() : SystemColumn.Active.getActiveValue();
            EntityConfig entityConfig = cls.getAnnotation(EntityConfig.class);
            boolean isLogUpdate = true;
            if (entityConfig != null && !entityConfig.update()) {
                isLogUpdate = false;
            }
            sql.append("update ").append(SqlUtil.getTableName(cls, false)).append(String.format(" set " + SystemColumn.Active.getColumn() + "=%d", status));
            if (isLogUpdate && SystemColumn.Modify.isStatus()) {
                sql.append(",").append(SystemColumn.Modify.getColumn()).append("=").append(SystemColumn.Modify.getTime());
            }
        }
        boolean isWhere = false;
        if (!StringUtils.isEmpty((String)ids)) {
            sql.append(" where id in(").append(ids).append(")");
            isWhere = true;
        }
        if (!StringUtils.isEmpty((String)where)) {
            sql.append(isWhere ? " and " : " where ").append(where);
        }
        return sql.toString();
    }

    public static String getSelectSql(Select<?> select) throws IllegalArgumentException, IllegalAccessException {
        StringBuilder sql = new StringBuilder("select ");
        sql.append(select.getColumns()).append(" from ").append(SqlUtil.getTableName(select.getTclass(), true, select.getIndex(), false)).append(" ");
        boolean isWhere = false;
        if (!StringUtils.isEmpty((String)StringUtil.convertNULL((Object)select.getKeyValue()))) {
            isWhere = true;
            sql.append("where ").append(select.getKeyColumn()).append("=").append("'").append(select.getKeyValue()).append("'");
        }
        if (!StringUtils.isEmpty((String)select.getWhere())) {
            sql.append(isWhere ? " and " : " where ").append(select.getWhere());
            if (!isWhere) {
                isWhere = true;
            }
        }
        if (select.getIsDelete() != -100) {
            sql.append(isWhere ? " and " : " where ").append(SystemColumn.Active.getColumn()).append("=").append(select.getIsDelete());
        }
        if (!StringUtils.isEmpty((String)select.getOrderBy())) {
            sql.append(" order by ").append(select.getOrderBy());
        }
        if (select.getLimitStart() == 0 && select.getLimitCount() != 0) {
            sql.append(" limit ").append(select.getLimitCount());
        } else if (select.getLimitStart() > 0) {
            sql.append(" limit ").append(select.getLimitStart()).append(",").append(select.getLimitCount());
        }
        return sql.toString();
    }

    private static String getMysqlPageSql(Page<?> page, StringBuffer sqlBuffer) {
        long offset = (page.getPageNo() - 1L) * page.getPageSize();
        SqlUtil.doWhere(sqlBuffer, page);
        if (page.getOrderBy() != null && !"".equals(page.getOrderBy())) {
            sqlBuffer.append(" order by ").append(page.getOrderBy());
        }
        sqlBuffer.append(" limit ").append(offset).append(",").append(page.getPageSize());
        return sqlBuffer.toString();
    }

    private static void doWhere(StringBuffer sqlBuffer, Page page) {
        if (!StringUtils.isEmpty((String)page.getWhereWord())) {
            if (sqlBuffer.indexOf("where") == -1) {
                sqlBuffer.append(" where ");
            } else {
                sqlBuffer.append(" and ");
            }
            sqlBuffer.append(page.getWhereWord());
        }
    }

    private static String getCountSql(String sql, Page<?> page) {
        StringBuffer sqlBuffer = new StringBuffer(sql);
        SqlUtil.doWhere(sqlBuffer, page);
        return "select count(1)  as count from (" + sqlBuffer + ") as total";
    }

    private static String getTableName(Class<?> class1) {
        return SqlUtil.getTableName(class1, true, null, false);
    }

    private static String getTableName(Class<?> class1, boolean isIndex) {
        return SqlUtil.getTableName(class1, isIndex, null, false);
    }

    private static String getTableName(Class<?> class1, boolean isIndex, String index, boolean isDatabaseName) {
        return EntityInfo.getTableName(class1, isIndex, index, isDatabaseName);
    }

    public static String function(String functionName, List<Object> parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append(functionName).append("(");
        if (parameters != null && parameters.size() > 0) {
            for (int i = 0; i < parameters.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("?");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private static String makeInsertToTableSql(Class<?> class1, int createUser, Collection<String> names, HashMap<String, String> systemMap, int isDeleteValue) {
        String tableName = SqlUtil.getTableName(class1, false);
        StringBuilder sql = new StringBuilder().append("insert into ").append(tableName).append("(");
        int nameCount = 0;
        StringBuilder value = new StringBuilder();
        boolean isDelete = false;
        for (String name : names) {
            if (nameCount > 0) {
                sql.append(",");
            }
            sql.append(name);
            String va = systemMap.get(name);
            if (nameCount > 0) {
                value.append(",");
            }
            if (va == null) {
                value.append("?");
            } else if (isDeleteValue != -100 && SystemColumn.Active.getColumn().equals(name)) {
                value.append(isDeleteValue);
                isDelete = true;
            } else {
                value.append(va);
            }
            ++nameCount;
        }
        if (createUser != -1 && ModifyUser.Create.isCreateClass(class1)) {
            sql.append(",").append(ModifyUser.Create.getColumnUser());
            value.append(",").append(createUser);
        }
        if (isDeleteValue != -100 && !isDelete) {
            sql.append(",").append(SystemColumn.Active.getColumn());
            value.append(",").append(isDeleteValue);
        }
        sql.append(") values (");
        sql.append((CharSequence)value);
        sql.append(")");
        return sql.toString();
    }

    private static String makeUpdateToTableSql(String tableName, Collection<String> names, HashMap<String, String> systemMap, boolean isLogUpdate) {
        String time;
        StringBuilder sql = new StringBuilder().append("update ").append(tableName).append(" set ");
        int nameCount = 0;
        for (String name : names) {
            if (nameCount > 0) {
                sql.append(",");
            }
            sql.append(name);
            sql.append("=");
            String va = systemMap.get(name);
            if (va == null) {
                sql.append("?");
            } else {
                sql.append(va);
            }
            ++nameCount;
        }
        if (isLogUpdate && SystemColumn.Modify.isStatus() && sql.indexOf(time = SystemColumn.Modify.getColumn() + "=" + SystemColumn.Modify.getTime()) == -1) {
            sql.append(",").append(time);
        }
        return sql.toString();
    }

    private static String makeUpdateToTableSql(String tableName, HashMap<String, Object> columns, boolean isLogUpdate) {
        StringBuilder sql = new StringBuilder().append("update ").append(tableName).append(" set ");
        int nameCount = 0;
        Iterator<Map.Entry<String, Object>> iterator = columns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String name = entry.getKey();
            Object obj_value = entry.getValue();
            if (nameCount > 0) {
                sql.append(",");
            }
            sql.append(name);
            sql.append("=");
            String va = SystemColumn.getDefaultValue(name);
            if (va == null) {
                if (SystemColumn.getPwdColumn().equalsIgnoreCase(name)) {
                    sql.append("PASSWORD(?)");
                } else {
                    String value = StringUtil.convertNULL((Object)obj_value);
                    if (value.startsWith("#{") && value.endsWith("}")) {
                        value = value.substring(value.indexOf("#{") + 2, value.indexOf("}"));
                        sql.append(value);
                        iterator.remove();
                    } else {
                        sql.append("?");
                    }
                }
            } else {
                sql.append(va);
            }
            ++nameCount;
        }
        if (isLogUpdate && SystemColumn.Modify.isStatus()) {
            sql.append(",").append(SystemColumn.Modify.getColumn()).append("=").append(SystemColumn.Modify.getTime());
        }
        return sql.toString();
    }
}

