/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.system;

import cn.jiangzeyin.system.SystemDbLog;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DBExecutorService {
    private static final ThreadPoolExecutor THREAD_POOL_EXECUTOR = DBExecutorService.newCachedThreadPool();

    private static ThreadPoolExecutor newCachedThreadPool() {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(50, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        executorService.setRejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy());
        SystemThreadFactory systemThreadFactory = new SystemThreadFactory("dbutil");
        executorService.setThreadFactory(systemThreadFactory);
        return executorService;
    }

    public static void shutdown() {
        SystemDbLog.getInstance().info("\u5173\u95ed\u6570\u636e\u5e93\u4f7f\u7528\u7684\u7ebf\u7a0b\u6c60");
        THREAD_POOL_EXECUTOR.shutdown();
    }

    public static void execute(Runnable command) {
        THREAD_POOL_EXECUTOR.execute(command);
    }

    private static class SystemThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        public int getThreadNumber() {
            return this.threadNumber.get();
        }

        SystemThreadFactory(String poolName) {
            SecurityManager s;
            if (poolName == null || poolName.isEmpty()) {
                poolName = "pool";
            }
            this.group = (s = System.getSecurityManager()) != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = poolName + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

