/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.run.read;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.database.DbWriteService;
import cn.jiangzeyin.database.base.ReadBase;
import cn.jiangzeyin.database.config.DatabaseContextHolder;
import cn.jiangzeyin.database.config.SystemColumn;
import cn.jiangzeyin.database.util.SqlUtil;
import cn.jiangzeyin.database.util.Util;
import cn.jiangzeyin.system.DbLog;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class Select<T>
extends ReadBase<T> {
    private String where;
    private String orderBy;
    private String sql;
    private int limitStart;
    private int limitCount;
    private Object keyValue;
    private String keyColumn;

    public String getKeyColumn() {
        if (StringUtils.isEmpty((String)this.keyColumn)) {
            return SystemColumn.getDefaultKeyName();
        }
        return this.keyColumn;
    }

    public void setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
    }

    public Object getKeyValue() {
        return this.keyValue;
    }

    public void setKeyValue(Object keyValue) {
        this.keyValue = keyValue;
    }

    public int getLimitStart() {
        return this.limitStart;
    }

    public void setLimitStart(int limitStart) {
        this.limitStart = limitStart;
    }

    public int getLimitCount() {
        return this.limitCount;
    }

    public void setLimitCount(int limitCount) {
        this.limitCount = limitCount;
    }

    public Select() {
    }

    public Select(int isDelete) {
        this.setIsDelete(isDelete);
    }

    public Select(String tag) {
        super.setTag(tag);
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public void appendWhere(String where) {
        String temp = StringUtil.convertNULL((String)this.where);
        where = StringUtil.convertNULL((String)where);
        this.where = String.format("%s %s", temp, where);
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setSql(String sql, ReadBase.Result resultType) {
        this.sql = sql;
        this.setResultType(resultType);
    }

    public T run(ReadBase.Result resultType) {
        this.setResultType(resultType);
        return this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T run() {
        try {
            if (this.getResultType() == ReadBase.Result.JsonObject) {
                this.setLimitCount(1);
            }
            String tag = this.getTag() == null ? DbWriteService.getDatabaseName(this.getTclass()) : this.getTag();
            this.setTag(tag);
            DataSource dataSource = DatabaseContextHolder.getReadDataSource(tag);
            String runSql = this.getSql();
            if (StringUtils.isEmpty((String)runSql)) {
                runSql = SqlUtil.getSelectSql(this);
            }
            this.setRunSql(runSql);
            DbLog.getInstance().info(this.getTransferLog() + runSql);
            List result = JdbcUtils.executeQuery((DataSource)dataSource, (String)runSql, this.getParameters());
            switch (this.getResultType()) {
                case JsonArray: {
                    Object object = JSON.toJSON((Object)result);
                    return (T)object;
                }
                case JsonObject: {
                    if (result != null && result.size() >= 1) {
                        Map map = (Map)result.get(0);
                        JSONObject jSONObject = new JSONObject(map);
                        return (T)jSONObject;
                    }
                    T t = null;
                    return t;
                }
                case Entity: {
                    List map = Util.convertList(this, result);
                    return (T)map;
                }
                case ListMap: {
                    List map = result;
                    return (T)map;
                }
                case String: 
                case Integer: {
                    if (result == null || result.size() < 1) {
                        T map = null;
                        return map;
                    }
                    Map map = (Map)result.get(0);
                    if (map == null) {
                        T t = null;
                        return t;
                    }
                    String column = this.getColumns();
                    if (SystemColumn.getDefaultSelectColumns().equals(column)) {
                        Object object = map.values().toArray()[0];
                        return (T)object;
                    }
                    String[] columns = StringUtil.stringToArray((String)column);
                    if (columns.length == 1) {
                        Object v = map.get(columns[0]);
                        return (T)v;
                    }
                    Map map2 = map;
                    return (T)map2;
                }
            }
            return null;
        }
        catch (Exception e) {
            this.isThrows(e);
            return null;
        }
        finally {
            this.runEnd();
            this.recycling();
        }
    }

    public T runOne() {
        this.setLimitCount(1);
        List list = (List)this.run();
        if (list == null) {
            return null;
        }
        if (list.size() > 0) {
            return (T)list.get(0);
        }
        return null;
    }
}

