/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.run.write;

import cn.jiangzeyin.database.DbWriteService;
import cn.jiangzeyin.database.base.WriteBase;
import cn.jiangzeyin.database.config.DatabaseContextHolder;
import cn.jiangzeyin.database.config.SystemColumn;
import cn.jiangzeyin.database.event.UpdateEvent;
import cn.jiangzeyin.database.util.SqlAndParameters;
import cn.jiangzeyin.database.util.SqlUtil;
import cn.jiangzeyin.system.DBExecutorService;
import cn.jiangzeyin.system.DbLog;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;

public class Update<T>
extends WriteBase<T> {
    private String where;
    private List<Object> whereParameters;
    private Object keyValue;
    private String keyColumn;
    private HashMap<String, Object> update;
    private UpdateEvent event;

    public UpdateEvent getEvent() {
        return this.event;
    }

    public void setEvent(UpdateEvent event) {
        this.event = event;
    }

    public Update(T data) {
        super(data);
    }

    public Update(T data, UpdateEvent event) {
        super(data);
        this.event = event;
    }

    public Update(T data, boolean isThrows) {
        super(data);
        this.setThrows(isThrows);
    }

    public Update() {
        super(null);
    }

    public Update(boolean isThrows) {
        super(null);
        this.setThrows(isThrows);
    }

    public HashMap<String, Object> getUpdate() {
        return this.update;
    }

    public void setUpdate(HashMap<String, Object> update) {
        this.update = update;
    }

    public void putUpdate(String column, Object value) {
        if (SystemColumn.notCanUpdate(column)) {
            throw new IllegalArgumentException(column + " not update");
        }
        if (this.update == null) {
            this.update = new HashMap();
        }
        this.update.put(column, value);
    }

    public Object getKeyValue() {
        return this.keyValue;
    }

    public void setKeyValue(Object keyValue) {
        this.keyValue = keyValue;
    }

    public String getKeyColumn() {
        if (StringUtils.isEmpty((String)this.keyColumn)) {
            return SystemColumn.getDefaultKeyName();
        }
        return this.keyColumn;
    }

    public void setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public void AppendWhere(String where) {
        this.where = StringUtils.isEmpty((String)this.where) ? where : this.where + " and " + where;
    }

    public List<Object> getWhereParameters() {
        return this.whereParameters;
    }

    public void setWhereParameters(List<Object> whereParameters) {
        this.whereParameters = whereParameters;
    }

    public void setWhereParameters(Object ... whereParameters) {
        if (this.whereParameters == null) {
            this.whereParameters = new LinkedList<Object>();
        }
        Collections.addAll(this.whereParameters, whereParameters);
    }

    @Override
    public void run() {
        this.setAsync(true);
        this.setThrowable(new Throwable());
        this.getAsyncLog();
        DBExecutorService.execute(this::syncRun);
    }

    @Override
    public Class<?> getTclass() {
        Object t = this.getData();
        if (t != null) {
            return t.getClass();
        }
        return super.getTclass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long syncRun() {
        try {
            Object data = this.getData();
            String tag = data == null ? DbWriteService.getDatabaseName(this.getTclass()) : DbWriteService.getDatabaseName(data);
            SqlAndParameters sqlAndParameters = SqlUtil.getUpdateSql(this);
            DataSource dataSource = DatabaseContextHolder.getWriteDataSource(tag);
            DbLog.getInstance().info(this.getTransferLog() + sqlAndParameters.getSql());
            this.setRunSql(sqlAndParameters.getSql());
            int count = JdbcUtils.executeUpdate((DataSource)dataSource, (String)sqlAndParameters.getSql(), sqlAndParameters.getParameters());
            if (this.event != null) {
                this.event.completeU(this.getKeyValue());
            }
            long l = count;
            return l;
        }
        catch (Exception e) {
            this.isThrows(e);
            if (this.event != null) {
                this.event.errorU(e);
            }
        }
        finally {
            this.runEnd();
            this.recycling();
            this.update = null;
            this.whereParameters = null;
            this.event = null;
        }
        return 0L;
    }
}

