/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.util;

import cn.jiangzeyin.database.base.ReadBase;
import cn.jiangzeyin.database.config.DatabaseContextHolder;
import cn.jiangzeyin.database.config.SystemColumn;
import cn.jiangzeyin.database.util.SqlUtil;
import cn.jiangzeyin.system.DbLog;
import cn.jiangzeyin.util.Assert;
import cn.jiangzeyin.util.DbReflectUtil;
import cn.jiangzeyin.util.KeyMap;
import com.alibaba.druid.util.JdbcUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class Util {
    public static <T> List<T> convertList(ReadBase<T> reBase, List<Map<String, Object>> list) throws Exception {
        Assert.notNull(list, "list map");
        Assert.notNull(reBase, "reBase");
        ArrayList<T> list_r = new ArrayList<T>();
        for (Map<String, Object> t : list) {
            list_r.add(Util.convertMap(reBase, t, null));
        }
        return list_r;
    }

    private static <T> T convertMap(ReadBase<T> read, Map<String, Object> map, Class<?> refClass) throws Exception {
        Object obj;
        if (refClass == null) {
            refClass = read.getTclass();
        }
        if ((obj = refClass.newInstance()) == null) {
            return null;
        }
        KeyMap<String, Object> keyMap = new KeyMap<String, Object>(map);
        HashMap<String, Class<?>> refMap = read.getRefMap();
        HashMap<String, String> refWhere = read.getRefWhere();
        List<String> remove = read.getRemove();
        List methods = DbReflectUtil.getAllSetMethods(obj.getClass());
        DataSource dataSource = DatabaseContextHolder.getReadDataSource(read.getTag());
        for (Method method : methods) {
            Object value;
            String name = method.getName();
            if (!name.startsWith("set")) continue;
            name = name.substring(3).toLowerCase();
            if (remove != null && remove.contains(name) || SystemColumn.isReadRemove(name) || (value = keyMap.get(name)) == null) continue;
            if (refMap != null && refMap.containsKey(name)) {
                String where = refWhere == null ? null : refWhere.get(name);
                Class<?> refMapClass = refMap.get(name);
                String sql = SqlUtil.getRefSql(refMapClass, read.getRefKey(), where);
                DbLog.getInstance().info(sql);
                ArrayList<Object> parameters = new ArrayList<Object>();
                parameters.add(value);
                List refList = JdbcUtils.executeQuery((DataSource)dataSource, (String)sql, parameters);
                if (refList == null || refList.size() <= 0) continue;
                Map refMap_data = (Map)refList.get(0);
                T refValue = Util.convertMap(read, refMap_data, refMapClass);
                try {
                    method.invoke(obj, refValue);
                }
                catch (IllegalArgumentException e) {
                    DbLog.getInstance().error(String.format(obj.getClass() + " map\u8f6c\u5b9e\u4f53%s\u5b57\u6bb5\u9519\u8bef\uff1a%s -> %s", name, value.getClass(), value), e);
                }
                continue;
            }
            try {
                method.invoke(obj, value);
            }
            catch (IllegalArgumentException ie) {
                Class<?>[] classes = method.getParameterTypes();
                Class<?> pClass = classes[0];
                if (pClass == String.class) {
                    method.invoke(obj, String.valueOf(value.toString()));
                    continue;
                }
                if (pClass == Integer.class || pClass == Integer.TYPE) {
                    method.invoke(obj, (Integer)value);
                    continue;
                }
                DbLog.getInstance().error(String.format(obj.getClass() + " map\u8f6c\u5b9e\u4f53%s\u5b57\u6bb5\u7c7b\u578b\u9519\u8bef\uff1a%s -> %s", name, value.getClass(), value), ie);
            }
            catch (Exception e) {
                DbLog.getInstance().error(String.format(obj.getClass() + " map\u8f6c\u5b9e\u4f53%s\u5b57\u6bb5\u9519\u8bef\uff1a%s -> %s", name, value.getClass(), value), e);
            }
        }
        return (T)obj;
    }
}

