/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util;

import cn.jiangzeyin.util.Assert;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class DbReflectUtil {
    public static Object getFieldValue(Object obj, String fieldName) throws NoSuchFieldException, IllegalAccessException {
        Assert.notNull(obj);
        Field field = DbReflectUtil.getField(obj.getClass(), fieldName);
        return field.get(obj);
    }

    public static List getDeclaredFields(Class<?> cls) {
        String key = cls.getName() + "_DeclaredFields";
        Object object = ReflectCache.get(key);
        if (object instanceof List) {
            return (List)object;
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (Class<?> clazz = cls; clazz != Object.class; clazz = clazz.getSuperclass()) {
            fieldList.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        ReflectCache.put(key, fieldList);
        return fieldList;
    }

    private static Field getField(Class<?> cls, String fieldName) throws NoSuchFieldException {
        String key = cls.getName() + "_" + fieldName;
        Object object = ReflectCache.get(key);
        if (object instanceof Field) {
            return (Field)object;
        }
        Field field = null;
        NoSuchFieldException noSuchFieldException = null;
        for (Class<?> clazz = cls; clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                break;
            }
            catch (NoSuchFieldException ignored) {
                noSuchFieldException = ignored;
                continue;
            }
        }
        if (field == null) {
            assert (noSuchFieldException != null);
            throw noSuchFieldException;
        }
        ReflectCache.put(key, field);
        return field;
    }

    public static void setFieldValue(Object obj, String fieldName, Object fieldValue) throws IllegalAccessException, NoSuchFieldException {
        Field field = DbReflectUtil.getField(obj.getClass(), fieldName);
        Class<?> type = field.getType();
        if (fieldValue == null) {
            field.set(obj, null);
            return;
        }
        if (type == Integer.TYPE) {
            field.set(obj, Integer.parseInt(fieldValue.toString()));
            return;
        }
        if (type == Integer.class) {
            field.set(obj, Integer.valueOf(fieldValue.toString()));
            return;
        }
        if (type == Double.TYPE) {
            field.set(obj, Double.parseDouble(fieldValue.toString()));
            return;
        }
        if (type == String.class) {
            field.set(obj, fieldValue.toString());
            return;
        }
        if (type == Long.TYPE) {
            field.set(obj, Long.parseLong(fieldValue.toString()));
            return;
        }
        field.set(obj, fieldValue);
    }

    public static Class<?> getTClass(Class<?> cls) {
        Type type = cls.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getActualTypeArguments()[0];
            return (Class)type;
        }
        return null;
    }

    public static List getAllSetMethods(Class cls) {
        return DbReflectUtil.getAllMethods(cls, "set");
    }

    private static List getAllMethods(Class cls, String prefix) {
        Assert.notNull(cls);
        String key = cls.getName() + "_" + prefix;
        Object object = ReflectCache.get(key);
        if (object instanceof List) {
            return (List)object;
        }
        ArrayList<Method> list = new ArrayList<Method>();
        for (Class clazz = cls; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!method.getName().startsWith(prefix)) continue;
                list.add(method);
            }
        }
        ReflectCache.put(key, list);
        return list;
    }

    private static final class ReflectCache {
        private static final ConcurrentHashMap<String, Object> CACHE = new ConcurrentHashMap();

        private ReflectCache() {
        }

        static void put(String key, Object object) {
            CACHE.put(key, object);
        }

        static Object get(String key) {
            return CACHE.get(key);
        }
    }
}

