/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.run.write;

import cn.jiangzeyin.database.config.DatabaseContextHolder;
import cn.jiangzeyin.database.run.write.Insert;
import cn.jiangzeyin.database.run.write.Remove;
import cn.jiangzeyin.database.run.write.Update;
import cn.jiangzeyin.system.DbLog;
import java.sql.Connection;
import java.sql.SQLException;

public class Transaction {
    private Connection connection;

    public Transaction(String tag, Callback callback) throws SQLException {
        this.connection = DatabaseContextHolder.getWriteConnection(tag);
        this.connection.setAutoCommit(false);
        Operate operate = new Operate(this);
        callback.start(operate);
    }

    private void commit() {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            DbLog.getInstance().error("commit", e);
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                DbLog.getInstance().error("rollback", e1);
            }
        }
        finally {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                DbLog.getInstance().error("finally close", e);
            }
        }
    }

    private void rollback() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            DbLog.getInstance().error("rollback", e);
        }
        finally {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                DbLog.getInstance().error("finally close", e);
            }
        }
    }

    public class Operate {
        private Transaction transaction;

        Operate(Transaction transaction) {
            this.transaction = transaction;
        }

        public Insert getInsert() {
            return new Insert(this.transaction.connection);
        }

        public Update getUpdate() {
            return new Update(this.transaction.connection);
        }

        public Remove getRemove() {
            return new Remove(this.transaction.connection);
        }

        public void commit() {
            this.transaction.commit();
        }

        public void rollback() {
            this.transaction.rollback();
        }
    }

    public static interface Callback {
        public void start(Operate var1);
    }
}

