/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.run.write;

import cn.jiangzeyin.database.DbWriteService;
import cn.jiangzeyin.database.base.WriteBase;
import cn.jiangzeyin.database.config.DatabaseContextHolder;
import cn.jiangzeyin.database.config.SystemColumn;
import cn.jiangzeyin.database.event.UpdateEvent;
import cn.jiangzeyin.database.util.SqlAndParameters;
import cn.jiangzeyin.database.util.SqlUtil;
import cn.jiangzeyin.system.DBExecutorService;
import cn.jiangzeyin.system.DbLog;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import java.sql.Connection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;

public class Update<T>
extends WriteBase<T> {
    private String where;
    private List<Object> whereParameters;
    private Object keyValue;
    private String keyColumn;
    private HashMap<String, Object> update;

    public Update(T data) {
        super(data);
    }

    Update(Connection connection) {
        super(connection);
    }

    public Update(T data, boolean isThrows) {
        super(data);
        this.setThrows(isThrows);
    }

    public Update() {
        super(null);
    }

    public Update(boolean isThrows) {
        super(null);
        this.setThrows(isThrows);
    }

    public HashMap<String, Object> getUpdate() {
        return this.update;
    }

    public void setUpdate(HashMap<String, Object> update) {
        Update.checkUpdate(this.getTclass(), update);
        this.update = update;
    }

    public void putUpdate(String column, Object value) {
        if (SystemColumn.notCanUpdate(column)) {
            throw new IllegalArgumentException(column + " not update");
        }
        if (SystemColumn.isSequence(this.getTclass(), column)) {
            throw new IllegalArgumentException(column + " not update sequence");
        }
        if (this.update == null) {
            this.update = new HashMap();
        }
        this.update.put(column, value);
    }

    public Object getKeyValue() {
        return this.keyValue;
    }

    public void setKeyValue(Object keyValue) {
        this.keyValue = keyValue;
    }

    public String getKeyColumn() {
        if (StringUtils.isEmpty((String)this.keyColumn)) {
            return SystemColumn.getDefaultKeyName();
        }
        return this.keyColumn;
    }

    public void setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public void AppendWhere(String where) {
        this.where = StringUtils.isEmpty((String)this.where) ? where : this.where + " and " + where;
    }

    public List<Object> getWhereParameters() {
        return this.whereParameters;
    }

    public void setWhereParameters(List<Object> whereParameters) {
        this.whereParameters = whereParameters;
    }

    public void setWhereParameters(Object ... whereParameters) {
        if (this.whereParameters == null) {
            this.whereParameters = new LinkedList<Object>();
        }
        Collections.addAll(this.whereParameters, whereParameters);
    }

    @Override
    public void run() {
        if (this.transactionConnection != null) {
            throw new RuntimeException("Transaction must sync");
        }
        this.setAsync();
        this.setThrowable(new Throwable());
        this.getAsyncLog();
        DBExecutorService.execute(this::syncRun);
    }

    @Override
    public Class<?> getTclass() {
        Object t = this.getData();
        if (t != null) {
            return t.getClass();
        }
        return super.getTclass();
    }

    private UpdateEvent getEvent(Object data) {
        if (data != null && UpdateEvent.class.isAssignableFrom(data.getClass())) {
            return (UpdateEvent)data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int syncRun() {
        UpdateEvent event = null;
        try {
            int count;
            WriteBase.Event.BeforeCode beforeCode;
            String tag;
            WriteBase.Callback callback = this.getCallback();
            Object data = this.getData();
            if (data == null) {
                Class<?> tClass = this.getTclass();
                tag = DbWriteService.getInstance().getDatabaseName(tClass);
                if (UpdateEvent.class.isAssignableFrom(tClass)) {
                    event = (UpdateEvent)tClass.newInstance();
                }
            } else {
                tag = DbWriteService.getInstance().getDatabaseName(data.getClass());
                event = this.getEvent(data);
            }
            if (event != null && (beforeCode = event.beforeUpdate(this, data)) == WriteBase.Event.BeforeCode.END) {
                DbLog.getInstance().info("\u672c\u6b21\u6267\u884c\u53d6\u6d88\uff1a" + data + "  " + this.getUpdate());
                int n = beforeCode.getResultCode();
                return n;
            }
            SqlAndParameters sqlAndParameters = SqlUtil.getUpdateSql(this);
            String sql = sqlAndParameters.getSql();
            DbLog.getInstance().info(this.getTransferLog() + sql);
            this.setRunSql(sql);
            if (this.transactionConnection == null) {
                DataSource dataSource = DatabaseContextHolder.getWriteDataSource(tag);
                count = JdbcUtils.executeUpdate((DataSource)dataSource, (String)sql, sqlAndParameters.getParameters());
            } else {
                count = JdbcUtils.executeUpdate((Connection)this.transactionConnection, (String)sql, sqlAndParameters.getParameters());
            }
            Object keyValue = this.getKeyValue();
            if (event != null) {
                if (keyValue != null) {
                    event.completeUpdate(this.getKeyValue());
                } else {
                    event.completeUpdate(data);
                }
            }
            if (callback != null) {
                callback.success(keyValue);
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            this.isThrows(e);
            if (event != null) {
                event.errorUpdate(e);
            }
        }
        finally {
            this.runEnd();
            this.recycling();
            this.update = null;
            this.whereParameters = null;
        }
        return -1;
    }
}

