/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.base;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.database.base.Base;
import cn.jiangzeyin.database.config.SystemColumn;
import com.alibaba.druid.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class ReadBase<T>
extends Base<T> {
    protected String columns;
    private String index;
    private List<Object> parameters;
    private Result resultType = Result.Entity;
    private int isDelete = -100;
    private Object keyValue;
    private String keyColumn;
    private String where;
    private boolean useIndex;

    protected ReadBase() {
        this.setThrows(true);
    }

    public boolean isUseIndex() {
        return this.useIndex;
    }

    public ReadBase setUseIndex(boolean useIndex) {
        this.useIndex = useIndex;
        return this;
    }

    public String getWhere() {
        return this.where;
    }

    public ReadBase setWhere(String where) {
        this.where = where;
        return this;
    }

    public ReadBase appendWhere(String where) {
        String temp = StringUtil.convertNULL((String)this.where);
        where = StringUtil.convertNULL((String)where);
        this.where = String.format("%s %s", temp, where);
        return this;
    }

    public String getKeyColumn() {
        if (StringUtils.isEmpty((String)this.keyColumn)) {
            return SystemColumn.getDefaultKeyName();
        }
        return this.keyColumn;
    }

    public ReadBase setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
        return this;
    }

    public Object getKeyValue() {
        return this.keyValue;
    }

    public ReadBase setKeyValue(Object keyValue) {
        this.keyValue = keyValue;
        return this;
    }

    public int getIsDelete() {
        return this.isDelete;
    }

    public ReadBase setIsDelete(int isDelete) {
        this.isDelete = isDelete;
        return this;
    }

    protected Result getResultType() {
        return this.resultType;
    }

    public ReadBase setResultType(Result resultType) {
        this.resultType = resultType;
        return this;
    }

    public List<Object> getParameters() {
        if (this.parameters == null) {
            return new ArrayList<Object>();
        }
        return this.parameters;
    }

    public ReadBase setParameters(Object ... parameters) {
        if (this.parameters == null) {
            this.parameters = new LinkedList<Object>();
        }
        if (parameters != null) {
            Collections.addAll(this.parameters, parameters);
        }
        return this;
    }

    public ReadBase setParameters(List<Object> whereParameters) {
        this.parameters = whereParameters;
        return this;
    }

    public String getColumns() {
        if (StringUtils.isEmpty((String)this.columns)) {
            return SystemColumn.getDefaultSelectColumns();
        }
        return this.columns;
    }

    public ReadBase setColumns(String columns) {
        this.columns = columns;
        return this;
    }

    public String getIndex() {
        return this.index;
    }

    public ReadBase setIndex(String index) {
        this.index = index;
        return this;
    }

    public abstract <t> t run();

    protected String getRealColumnName(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return name;
        }
        String[] names = StringUtil.stringToArray((String)name, (String)" ");
        if (names.length > 1) {
            return names[names.length - 1];
        }
        return name.trim();
    }

    @Override
    protected void recycling() {
        super.recycling();
        this.parameters = null;
        this.resultType = null;
        this.columns = null;
        this.index = null;
    }

    public static enum Result {
        JsonArray,
        JsonObject,
        Entity,
        ListMap,
        String,
        Integer,
        PageResultType,
        ListOneColumn;

    }
}

