/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.run.read;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.database.DbWriteService;
import cn.jiangzeyin.database.base.ReadBase;
import cn.jiangzeyin.database.config.DatabaseContextHolder;
import cn.jiangzeyin.database.config.SystemColumn;
import cn.jiangzeyin.database.util.SqlUtil;
import cn.jiangzeyin.database.util.Util;
import cn.jiangzeyin.system.DbLog;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class Select<T>
extends ReadBase<T> {
    private String orderBy;
    private String sql;
    private int limitStart;
    private int limitCount;

    public int getLimitStart() {
        return this.limitStart;
    }

    public Select setLimitStart(int limitStart) {
        this.limitStart = limitStart;
        return this;
    }

    public int getLimitCount() {
        return this.limitCount;
    }

    public Select setLimitCount(int limitCount) {
        this.limitCount = limitCount;
        return this;
    }

    public Select() {
    }

    public Select(int isDelete) {
        this.setIsDelete(isDelete);
    }

    public Select(String tag) {
        super.setTag(tag);
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public Select setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void setSql(String sql, ReadBase.Result resultType) {
        this.sql = sql;
        this.setResultType(resultType);
    }

    public T run(ReadBase.Result resultType) {
        this.setResultType(resultType);
        return (T)this.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <t> t run() {
        try {
            if (this.getResultType() == ReadBase.Result.JsonObject) {
                this.setLimitCount(1);
            }
            String tag = this.getTag() == null ? DbWriteService.getInstance().getDatabaseName(this.getTclass()) : this.getTag();
            this.setTag(tag);
            DataSource dataSource = DatabaseContextHolder.getReadDataSource(tag);
            String runSql = this.getSql();
            if (StringUtils.isEmpty((String)runSql)) {
                runSql = SqlUtil.getSelectSql(this);
            }
            this.setRunSql(runSql);
            DbLog.getInstance().info(this.getTransferLog() + runSql);
            List result = JdbcUtils.executeQuery((DataSource)dataSource, (String)runSql, this.getParameters());
            switch (this.getResultType()) {
                case JsonArray: {
                    Object object = JSON.toJSON((Object)result);
                    return (t)object;
                }
                case JsonObject: {
                    if (result.size() < 1) {
                        t t = null;
                        return t;
                    }
                    Map map = (Map)result.get(0);
                    JSONObject jSONObject = new JSONObject(map);
                    return (t)jSONObject;
                }
                case Entity: {
                    List map = Util.convertList(this, result);
                    return (t)map;
                }
                case ListMap: {
                    List map = result;
                    return (t)map;
                }
                case String: 
                case Integer: {
                    if (result.size() < 1) {
                        t map = null;
                        return map;
                    }
                    Map map = (Map)result.get(0);
                    if (map == null) {
                        t t = null;
                        return t;
                    }
                    String column = this.getColumns();
                    if (SystemColumn.getDefaultSelectColumns().equals(column)) {
                        Object object = map.values().toArray()[0];
                        return (t)object;
                    }
                    String[] columns = StringUtil.stringToArray((String)column, (String)",");
                    if (columns != null && columns.length == 1) {
                        columns[0] = this.getRealColumnName(columns[0]);
                        Object v = map.get(columns[0]);
                        return (t)v;
                    }
                    Map map2 = map;
                    return (t)map2;
                }
                case ListOneColumn: {
                    String[] columns = StringUtil.stringToArray((String)this.getColumns(), (String)",");
                    if (columns == null || columns.length != 1) {
                        throw new IllegalArgumentException((Object)((Object)ReadBase.Result.ListOneColumn) + " must set one columns");
                    }
                    columns[0] = this.getRealColumnName(columns[0]);
                    ArrayList list = new ArrayList(result.size());
                    for (Map map : result) {
                        list.add(map.get(columns[0]));
                    }
                    ArrayList arrayList = list;
                    return (t)arrayList;
                }
            }
            List list = result;
            return (t)list;
        }
        catch (Exception e) {
            this.isThrows(e);
        }
        finally {
            this.runEnd();
            this.recycling();
        }
        return null;
    }

    public T runOne() {
        this.setLimitCount(1);
        List list = (List)this.run();
        if (list == null) {
            return null;
        }
        if (list.size() > 0) {
            return (T)list.get(0);
        }
        return null;
    }
}

