/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.sequence.impl;

import cn.jiangzeyin.DateUtil;
import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.sequence.BaseSequence;
import cn.jiangzeyin.sequence.ISequence;
import cn.jiangzeyin.sequence.SequenceConfig;
import com.alibaba.fastjson.JSONObject;

public class DateSequence
extends BaseSequence {
    public static ISequence instance() {
        return InstanceHolder.INSTANCE;
    }

    private DateSequence(int workerId, int dataCenterId) {
        super(workerId, dataCenterId, 8, 5, 12);
    }

    @Override
    public synchronized String nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        long suffix = (long)(this.dataCenterId << this.dataCenterIdShift | this.workerId << this.workerIdShift) | this.sequence;
        String datePrefix = DateUtil.formatTime((String)"yyyyMMddHHmmssSSS", (long)timestamp);
        return datePrefix + suffix;
    }

    @Override
    public JSONObject parseInfo(String id) {
        if (StringUtil.isEmpty((String)id)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("error", (Object)"id empty");
            return jsonObject;
        }
        if (id.length() < 17) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("error", (Object)"id error");
            return jsonObject;
        }
        String date = id.substring(0, 17);
        id = id.substring(17);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("date", (Object)date);
        id = Long.toBinaryString(Long.parseLong(id));
        if (StringUtil.parseLong((String)id) == 0L) {
            jsonObject.put("sequence", (Object)0);
            jsonObject.put("workerId", (Object)0);
            jsonObject.put("dataCenter", (Object)0);
            return jsonObject;
        }
        int len = id.length();
        int sequenceStart = len < this.workerIdShift ? 0 : len - this.workerIdShift;
        String sequence = id.substring(sequenceStart, len);
        int workerStart = len < this.dataCenterIdShift ? 0 : len - this.dataCenterIdShift;
        String workerId = sequenceStart == 0 ? "0" : id.substring(workerStart, sequenceStart);
        String dataCenterId = workerStart == 0 ? "0" : id.substring(0, workerStart);
        int sequenceInt = Integer.valueOf(sequence, 2);
        jsonObject.put("sequence", (Object)sequenceInt);
        int workerIdInt = Integer.valueOf(workerId, 2);
        jsonObject.put("workerId", (Object)workerIdInt);
        int dataCenterIdInt = Integer.valueOf(dataCenterId, 2);
        jsonObject.put("dataCenter", (Object)dataCenterIdInt);
        return jsonObject;
    }

    private static class InstanceHolder {
        static final ISequence INSTANCE = new DateSequence(SequenceConfig.getWorkerId(), SequenceConfig.getDataCenterId());

        private InstanceHolder() {
        }
    }
}

