/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.sequence.impl;

import cn.jiangzeyin.DateUtil;
import cn.jiangzeyin.sequence.BaseSequence;
import cn.jiangzeyin.sequence.ISequence;
import cn.jiangzeyin.sequence.SequenceConfig;
import com.alibaba.fastjson.JSONObject;
import java.text.ParseException;

public class IdSequence
extends BaseSequence {
    private static final long startTime;
    private final int timestampLeftShift;

    public static ISequence instance() {
        return InstanceHolder.INSTANCE;
    }

    private IdSequence(int workerId, int dataCenterId) {
        super(workerId, dataCenterId, 8, 5, 12);
        this.timestampLeftShift = this.sequenceBits + this.workerIdBits + this.dataCenterIdBits;
    }

    @Override
    public synchronized String nextId() {
        long timestamp;
        block8: {
            timestamp = this.timeGen();
            if (timestamp < this.lastTimestamp) {
                long offset = this.lastTimestamp - timestamp;
                if (offset <= 5L) {
                    try {
                        this.wait(offset << 1);
                        timestamp = this.timeGen();
                        if (timestamp < this.lastTimestamp) {
                            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", offset));
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", offset));
            }
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return String.valueOf(timestamp - startTime << this.timestampLeftShift | (long)(this.dataCenterId << this.dataCenterIdShift) | (long)(this.workerId << this.workerIdShift) | this.sequence);
    }

    @Override
    public JSONObject parseInfo(String id) {
        id = Long.toBinaryString(Long.parseLong(id));
        int len = id.length();
        JSONObject jsonObject = new JSONObject();
        int sequenceStart = len < this.workerIdShift ? 0 : len - this.workerIdShift;
        int workerStart = len < this.dataCenterIdShift ? 0 : len - this.dataCenterIdShift;
        int timeStart = len < this.timestampLeftShift ? 0 : len - this.timestampLeftShift;
        String sequence = id.substring(sequenceStart, len);
        String workerId = sequenceStart == 0 ? "0" : id.substring(workerStart, sequenceStart);
        String dataCenterId = workerStart == 0 ? "0" : id.substring(timeStart, workerStart);
        String time = timeStart == 0 ? "0" : id.substring(0, timeStart);
        int sequenceInt = Integer.valueOf(sequence, 2);
        jsonObject.put("sequence", (Object)sequenceInt);
        int workerIdInt = Integer.valueOf(workerId, 2);
        jsonObject.put("workerId", (Object)workerIdInt);
        int dataCenterIdInt = Integer.valueOf(dataCenterId, 2);
        jsonObject.put("dataCenter", (Object)dataCenterIdInt);
        long diffTime = Long.parseLong(time, 2);
        long timeLong = diffTime + startTime;
        String date = DateUtil.formatTime(null, (long)timeLong);
        jsonObject.put("date", (Object)date);
        return jsonObject;
    }

    static {
        long startTime1;
        try {
            startTime1 = DateUtil.parseTime((String)"2018-01-01", (String)"yyyy-MM-dd").getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            startTime1 = 0L;
        }
        startTime = startTime1;
    }

    private static class InstanceHolder {
        static final ISequence INSTANCE = new IdSequence(SequenceConfig.getWorkerId(), SequenceConfig.getDataCenterId());

        private InstanceHolder() {
        }
    }
}

