/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.run.read;

import cn.jiangzeyin.database.DbWriteService;
import cn.jiangzeyin.database.Page;
import cn.jiangzeyin.database.base.ReadBase;
import cn.jiangzeyin.database.config.DatabaseContextHolder;
import cn.jiangzeyin.database.util.SqlUtil;
import cn.jiangzeyin.database.util.Util;
import cn.jiangzeyin.system.DbLog;
import com.alibaba.druid.util.JdbcUtils;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;

public class SelectPage<T>
extends ReadBase<T> {
    private Page<T> page;

    public SelectPage(Page<T> page) {
        this.page = page;
    }

    public SelectPage(Page<T> page, ReadBase.Result resultType) {
        this.page = page;
        this.setResultType(resultType);
    }

    public Page<T> getPage() {
        return this.page;
    }

    public void setPage(Page<T> page) {
        this.page = page;
    }

    @Override
    public ReadBase setWhere(String where) {
        this.appendWhere(where);
        return this;
    }

    @Override
    public ReadBase appendWhere(String where) {
        throw new IllegalArgumentException("where please use page");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run() {
        Objects.requireNonNull(this.page, "page");
        String errorSql = null;
        try {
            Object countMap;
            String tag = this.getTag();
            if (StringUtils.isEmpty((String)tag)) {
                tag = DbWriteService.getInstance().getDatabaseName(this.getTclass());
                this.setTag(tag);
            }
            String[] pageSql = StringUtils.isEmpty((String)this.page.getSql()) ? SqlUtil.getSelectPageSql(this) : SqlUtil.getSelectPageSql(this.page);
            DataSource dataSource = DatabaseContextHolder.getReadDataSource(tag);
            long count = 0L;
            errorSql = pageSql[0];
            List<Map<String, Object>> list = JdbcUtils.executeQuery((DataSource)dataSource, (String)pageSql[0], this.getParameters());
            if (list.size() > 0 && (countMap = (Map)list.get(0)) != null) {
                count = (Long)countMap.values().toArray()[0];
            }
            this.page.setTotalRecord(count);
            if (count > 0L) {
                this.setRunSql(pageSql[1]);
                DbLog.getInstance().info(this.getTransferLog() + pageSql[1]);
                errorSql = null;
                list = JdbcUtils.executeQuery((DataSource)dataSource, (String)pageSql[1], this.getParameters());
            } else {
                list = new ArrayList<Map<String, Object>>();
            }
            this.page.setMapList(list);
            if (this.getResultType() == ReadBase.Result.JsonArray) {
                countMap = JSON.toJSON(list);
                return (T)countMap;
            }
            if (this.getResultType() == ReadBase.Result.PageResultType) {
                JSONObject data = new JSONObject();
                data.put("results", list);
                data.put("pageNo", (Object)this.page.getPageNo());
                data.put("pageSize", (Object)this.page.getPageSize());
                data.put("totalPage", (Object)this.page.getTotalPage());
                data.put("totalRecord", (Object)this.page.getTotalRecord());
                JSONObject jSONObject = data;
                return (T)jSONObject;
            }
            List resultList = Util.convertList(this, list);
            this.page.setResultsT(resultList);
            List list2 = resultList;
            return (T)list2;
        }
        catch (Exception e) {
            if (errorSql != null) {
                DbLog.getInstance().info(this.getTransferLog() + errorSql);
            }
            this.isThrows(e);
        }
        finally {
            this.runEnd();
            this.recycling();
        }
        return null;
    }
}

