/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.run.write;

import cn.jiangzeyin.database.DbWriteService;
import cn.jiangzeyin.database.TransactionError;
import cn.jiangzeyin.database.config.DatabaseContextHolder;
import cn.jiangzeyin.database.run.write.Insert;
import cn.jiangzeyin.database.run.write.Remove;
import cn.jiangzeyin.database.run.write.Update;
import cn.jiangzeyin.system.DbLog;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;

public class Transaction {
    private Connection connection;

    public Transaction(Class cls, Callback callback) {
        this(DbWriteService.getInstance().getDatabaseName(cls), callback);
    }

    public Transaction(String tag, Callback callback) {
        Objects.requireNonNull(callback);
        try {
            this.connection = DatabaseContextHolder.getWriteConnection(tag);
            this.connection.setAutoCommit(false);
        }
        catch (SQLException e) {
            callback.error(e);
            throw new TransactionError("Transaction init error:" + e.getMessage());
        }
        Operate operate = new Operate(this);
        try {
            callback.start(operate);
        }
        catch (Exception e) {
            callback.error(e);
            throw new TransactionError("Transaction error:" + e.getMessage());
        }
    }

    private void commit() {
        try {
            this.connection.commit();
        }
        catch (SQLException e) {
            DbLog.getInstance().error("commit", e);
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                DbLog.getInstance().error("rollback", e1);
            }
        }
        finally {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                DbLog.getInstance().error("finally close", e);
            }
        }
    }

    private void rollback() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            DbLog.getInstance().error("rollback", e);
        }
        finally {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                DbLog.getInstance().error("finally close", e);
            }
        }
    }

    public class Operate {
        private Transaction transaction;

        Operate(Transaction transaction) {
            Objects.requireNonNull(transaction);
            this.transaction = transaction;
        }

        public Insert getInsert() {
            return new Insert(this.transaction.connection);
        }

        public Update getUpdate() {
            return new Update(this.transaction.connection);
        }

        public Remove getRemove() {
            return new Remove(this.transaction.connection);
        }

        public void commit() {
            this.transaction.commit();
        }

        public void rollback() {
            if (this.transaction != null) {
                this.transaction.rollback();
            }
        }
    }

    public static interface Callback {
        public void start(Operate var1);

        public void error(Exception var1);
    }
}

