/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.util;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.database.DbWriteService;
import cn.jiangzeyin.database.Page;
import cn.jiangzeyin.database.annotation.EntityConfig;
import cn.jiangzeyin.database.annotation.FieldConfig;
import cn.jiangzeyin.database.base.Base;
import cn.jiangzeyin.database.base.ReadBase;
import cn.jiangzeyin.database.base.WriteBase;
import cn.jiangzeyin.database.config.ModifyUser;
import cn.jiangzeyin.database.config.SystemColumn;
import cn.jiangzeyin.database.run.read.IsExists;
import cn.jiangzeyin.database.run.read.Select;
import cn.jiangzeyin.database.run.read.SelectPage;
import cn.jiangzeyin.database.run.write.Insert;
import cn.jiangzeyin.database.run.write.Remove;
import cn.jiangzeyin.database.run.write.Update;
import cn.jiangzeyin.database.util.SqlAndParameters;
import cn.jiangzeyin.sequence.ISequence;
import cn.jiangzeyin.sequence.SequenceConfig;
import cn.jiangzeyin.util.DbReflectUtil;
import com.alibaba.druid.util.StringUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class SqlUtil {
    private static boolean isWrite(Field field) {
        return field.getModifiers() != 25 && field.getModifiers() != 26 && !field.getName().startsWith("_");
    }

    private static SqlAndParameters getWriteSql(WriteBase<?> write, Object data) throws Exception {
        String insertColumns_;
        String[] columns_;
        if (data == null) {
            data = write.getData();
        }
        Objects.requireNonNull(data, String.format("%s", write.getTclass(false)));
        ArrayList<String> columns = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        HashMap<String, String> systemMap = new HashMap<String, String>();
        List<String> remove = write.getRemove();
        HashMap<String, Class<?>> refMap = write.getRefMap();
        boolean isInsert = write instanceof Insert;
        Class<?> classT = data.getClass();
        EntityConfig entityConfig = null;
        ArrayList<String> insertColumns = null;
        if (isInsert && (entityConfig = classT.getAnnotation(EntityConfig.class)) != null && (columns_ = StringUtil.stringToArray((String)(insertColumns_ = entityConfig.insertColumns()), (String)",")) != null) {
            insertColumns = new ArrayList<String>();
            for (String column_item : columns_) {
                insertColumns.add(column_item.toLowerCase());
            }
        }
        List<Field> fieldList = DbReflectUtil.getDeclaredFields(classT);
        for (Field object : fieldList) {
            Class<? extends ISequence> sequenceCls;
            ISequence sequence;
            Field field = object;
            if (!SqlUtil.isWrite(field)) continue;
            String name = field.getName();
            if (remove != null && remove.contains(name.toLowerCase())) continue;
            FieldConfig fieldConfig = null;
            if (SystemColumn.isWriteRemove(name) && (insertColumns == null || !insertColumns.contains(name.toLowerCase())) && ((fieldConfig = field.getAnnotation(FieldConfig.class)) == null || (sequence = SequenceConfig.parseSequence(sequenceCls = fieldConfig.sequence())) == null) || entityConfig != null && (!entityConfig.baseMark() && "mark".equals(name) || !entityConfig.update() && name.equalsIgnoreCase(SystemColumn.Modify.getColumn()))) continue;
            if (isInsert) {
                if (fieldConfig == null) {
                    fieldConfig = field.getAnnotation(FieldConfig.class);
                }
                if (fieldConfig != null) {
                    String insertDelValue = fieldConfig.insertDefValue();
                    if (!StringUtil.isEmpty((String)insertDelValue)) {
                        columns.add(name);
                        systemMap.put(name, insertDelValue);
                        continue;
                    }
                    Class<? extends ISequence> sequenceCls2 = fieldConfig.sequence();
                    ISequence sequence2 = SequenceConfig.parseSequence(sequenceCls2);
                    if (sequence2 != null) {
                        columns.add(name);
                        String val = sequence2.nextId();
                        systemMap.put(name, val);
                        DbReflectUtil.setFieldValue(data, name, val);
                        continue;
                    }
                }
            }
            columns.add(name);
            String value1 = SystemColumn.getDefaultValue(name);
            if (value1 == null) {
                Object va = field.get(data);
                if (SystemColumn.getPwdColumn().equalsIgnoreCase(name)) {
                    systemMap.put(name, "PASSWORD(?)");
                    values.add(va);
                    continue;
                }
                if (refMap != null && refMap.containsKey(name.toLowerCase())) {
                    va = DbReflectUtil.getFieldValue(va, write.getRefKey());
                }
                values.add(va);
                continue;
            }
            systemMap.put(name, value1);
        }
        SqlAndParameters sqlAndParameters = new SqlAndParameters();
        sqlAndParameters.setParameters(values);
        sqlAndParameters.setColumns(columns);
        sqlAndParameters.setSystemMap(systemMap);
        return sqlAndParameters;
    }

    private static SqlAndParameters getWriteSql(WriteBase<?> write) throws Exception {
        return SqlUtil.getWriteSql(write, null);
    }

    public static SqlAndParameters getInsertSql(Insert<?> insert) throws Exception {
        EntityConfig entityConfig;
        SqlAndParameters sqlAndParameters = SqlUtil.getWriteSql(insert);
        int isDelete = -100;
        if (!StringUtils.isEmpty((String)SystemColumn.Active.getColumn()) && ((entityConfig = insert.getData().getClass().getAnnotation(EntityConfig.class)) == null || entityConfig.active())) {
            Object isDeleteF = DbReflectUtil.getFieldValue(insert.getData(), SystemColumn.Active.getColumn());
            isDelete = isDeleteF == null ? SystemColumn.Active.getActiveValue() : Integer.parseInt(isDeleteF.toString());
        }
        sqlAndParameters.setSql(SqlUtil.makeInsertToTableSql(insert.getData().getClass(), insert.getOptUserId(), sqlAndParameters.getColumns(), sqlAndParameters.getSystemMap(), isDelete));
        return sqlAndParameters;
    }

    public static SqlAndParameters[] getInsertSqls(Insert<?> insert) throws Exception {
        List<?> list = insert.getList();
        SqlAndParameters[] andParameters = new SqlAndParameters[list.size()];
        for (int i = 0; i < andParameters.length; ++i) {
            EntityConfig entityConfig;
            Object object = list.get(i);
            if (object == null) continue;
            SqlAndParameters sqlAndParameters = SqlUtil.getWriteSql(insert, object);
            int isDelete = -100;
            if (!StringUtils.isEmpty((String)SystemColumn.Active.getColumn()) && ((entityConfig = object.getClass().getAnnotation(EntityConfig.class)) == null || entityConfig.active())) {
                Object isDeleteF = DbReflectUtil.getFieldValue(object, SystemColumn.Active.getColumn());
                isDelete = isDeleteF == null ? SystemColumn.Active.getActiveValue() : Integer.parseInt(isDeleteF.toString());
            }
            sqlAndParameters.setSql(SqlUtil.makeInsertToTableSql(object.getClass(), insert.getOptUserId(), sqlAndParameters.getColumns(), sqlAndParameters.getSystemMap(), isDelete));
            andParameters[i] = sqlAndParameters;
        }
        return andParameters;
    }

    public static SqlAndParameters getUpdateSql(Update<?> update) throws Exception {
        List<Object> parameters;
        StringBuilder sbSql;
        String sql;
        SqlAndParameters sqlAndParameters;
        Class<?> class1 = update.getTclass();
        EntityConfig entityConfig = class1.getAnnotation(EntityConfig.class);
        boolean isLogUpdate = true;
        if (entityConfig != null && !entityConfig.update()) {
            isLogUpdate = false;
        }
        if (update.getUpdate() != null) {
            sqlAndParameters = new SqlAndParameters();
            sql = SqlUtil.makeUpdateToTableSql(SqlUtil.getTableName(update, class1), update.getUpdate(), isLogUpdate);
            sbSql = new StringBuilder(sql);
        } else {
            sqlAndParameters = SqlUtil.getWriteSql(update);
            sql = SqlUtil.makeUpdateToTableSql(SqlUtil.getTableName(update, class1), sqlAndParameters.getColumns(), sqlAndParameters.getSystemMap(), isLogUpdate);
            sbSql = new StringBuilder(sql);
        }
        SqlUtil.loadModifyUser(update, sbSql);
        boolean isAppendWhere = false;
        boolean isWhere = false;
        if (!StringUtils.isEmpty((String)StringUtil.convertNULL((Object)update.getKeyValue()))) {
            sbSql.append(" where ");
            sbSql.append(update.getKeyColumn());
            sbSql.append("=").append("'").append(update.getKeyValue()).append("'");
            isAppendWhere = true;
            isWhere = true;
        }
        if (!StringUtils.isEmpty((String)update.getWhere())) {
            sbSql.append(isAppendWhere ? " and " : " where ");
            sbSql.append(update.getWhere());
            isWhere = true;
        }
        if (!isWhere) {
            if (update.getData() != null) {
                Object objId = DbReflectUtil.getFieldValue(update.getData(), SystemColumn.getDefaultKeyName());
                Objects.requireNonNull(objId, "\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u66f4\u65b0\u6761\u4ef6");
                sbSql.append(" where id=");
                sbSql.append(Long.parseLong(objId.toString()));
            } else {
                sbSql.append(" where ").append(update.getKeyColumn()).append("=").append(update.getKeyValue());
            }
        }
        sqlAndParameters.setSql(sbSql);
        if (update.getUpdate() == null) {
            parameters = sqlAndParameters.getParameters();
        } else {
            LinkedList<Object> paList = new LinkedList<Object>();
            Collections.addAll(paList, update.getUpdate().values().toArray());
            parameters = paList;
        }
        if (parameters == null) {
            parameters = update.getWhereParameters();
        } else if (update.getWhereParameters() != null) {
            parameters.addAll(update.getWhereParameters());
        }
        sqlAndParameters.setParameters(parameters);
        return sqlAndParameters;
    }

    public static String[] getSelectPageSql(SelectPage<?> select) {
        StringBuffer sql = new StringBuffer("select ");
        sql.append(select.getColumns()).append(" from ").append(SqlUtil.getTableName(select)).append(" ");
        String[] countSql = new String[]{SqlUtil.getCountSql(sql.toString(), select.getPage()), SqlUtil.getMysqlPageSql(select.getPage(), sql)};
        return countSql;
    }

    public static String[] getSelectPageSql(Page<?> page) {
        StringBuffer sql = new StringBuffer(page.getSql());
        String[] countSql = new String[]{SqlUtil.getCountSql(sql.toString(), page), SqlUtil.getMysqlPageSql(page, sql)};
        return countSql;
    }

    static String getRefSql(Class<?> ref, String keyColumn, String where) {
        StringBuilder sql = new StringBuilder("select ").append(" * from ").append(SqlUtil.getTableName(null, ref)).append(" where ").append(keyColumn).append("=?");
        if (!StringUtils.isEmpty((String)where)) {
            sql.append(" and ").append(where);
        }
        return sql.toString();
    }

    public static String getIsExistsSql(IsExists isExists, Class<?> clas, String keyColumn, String where) {
        int limit;
        StringBuilder sql = new StringBuilder("select ");
        String column = isExists.getColumns();
        if (StringUtils.isEmpty((String)column)) {
            sql.append(" count(1) as countSum from ");
        } else {
            sql.append(" ").append(column).append(" from ");
        }
        sql.append(SqlUtil.getTableName(isExists, clas)).append(" where ").append(keyColumn).append("=?");
        if (!StringUtils.isEmpty((String)where)) {
            String tempWhere = where.toLowerCase().trim();
            sql.append(tempWhere.startsWith("or") ? "" : " and ").append(where);
        }
        if ((limit = isExists.getLimit()) <= 0) {
            limit = 1;
        }
        sql.append(" limit ").append(limit);
        return sql.toString();
    }

    public static String getRemoveSql(Remove<?> remove) {
        String where = remove.getWhere();
        Class<?> cls = remove.getTclass();
        Remove.Type type = remove.getType();
        String ids = remove.getIds();
        StringBuilder sql = new StringBuilder();
        if (type == Remove.Type.delete) {
            sql.append("delete from ").append(SqlUtil.getTableName(remove, cls));
        } else {
            HashMap<String, Object> columns;
            int status = type == Remove.Type.remove ? SystemColumn.Active.getInActiveValue() : SystemColumn.Active.getActiveValue();
            EntityConfig entityConfig = cls.getAnnotation(EntityConfig.class);
            boolean isLogUpdate = true;
            if (entityConfig != null && !entityConfig.update()) {
                isLogUpdate = false;
            }
            sql.append("update ").append(SqlUtil.getTableName(remove, cls)).append(String.format(" set " + SystemColumn.Active.getColumn() + "=%d", status));
            if (isLogUpdate && SystemColumn.Modify.isStatus()) {
                sql.append(",").append(SystemColumn.Modify.getColumn()).append("=").append(SystemColumn.Modify.getTime());
            }
            if (type == Remove.Type.recovery && (columns = remove.getUpdate()) != null) {
                sql.append(",");
                SqlUtil.makeUpdateColumns(sql, columns);
                LinkedList<Object> list = new LinkedList<Object>(columns.values());
                List<Object> oldList = remove.getParameters();
                remove.setParameters(list);
                if (oldList != null) {
                    remove.setParameters(oldList.toArray());
                }
            }
            SqlUtil.loadModifyUser(remove, sql);
        }
        boolean isWhere = false;
        if (!StringUtils.isEmpty((String)ids)) {
            sql.append(" where id in(").append(ids).append(")");
            isWhere = true;
        }
        if (!StringUtils.isEmpty((String)where)) {
            sql.append(isWhere ? " and " : " where ").append(where);
            isWhere = true;
        }
        if (!isWhere) {
            throw new IllegalArgumentException("remove must have where");
        }
        return sql.toString();
    }

    private static void loadModifyUser(Base<?> base, StringBuilder stringBuffer) {
        int optUserId = base.getOptUserId();
        if (optUserId < 1) {
            return;
        }
        Class<?> cls = base.getTclass();
        if (ModifyUser.Modify.isModifyClass(cls)) {
            stringBuffer.append(",").append(ModifyUser.Modify.getColumnUser()).append("=").append(optUserId);
            stringBuffer.append(",").append(ModifyUser.Modify.getColumnTime()).append("=").append(ModifyUser.Modify.getModifyTime());
        }
    }

    public static String getSelectSql(Select<?> select) throws IllegalArgumentException {
        StringBuilder sql = new StringBuilder("select ");
        sql.append(select.getColumns()).append(" from ").append(SqlUtil.getTableName(select)).append(" ");
        boolean isWhere = false;
        if (!StringUtils.isEmpty((String)StringUtil.convertNULL((Object)select.getKeyValue()))) {
            isWhere = true;
            sql.append("where ").append(select.getKeyColumn()).append("=").append("'").append(select.getKeyValue()).append("'");
        }
        if (!StringUtils.isEmpty((String)select.getWhere())) {
            sql.append(isWhere ? " and " : " where ").append(select.getWhere());
            if (!isWhere) {
                isWhere = true;
            }
        }
        if (select.getIsDelete() != -100) {
            sql.append(isWhere ? " and " : " where ").append(SystemColumn.Active.getColumn()).append("=").append(select.getIsDelete());
        }
        if (!StringUtils.isEmpty((String)select.getOrderBy())) {
            sql.append(" order by ").append(select.getOrderBy());
        }
        if (select.getLimitStart() == 0 && select.getLimitCount() != 0) {
            sql.append(" limit ").append(select.getLimitCount());
        } else if (select.getLimitStart() > 0) {
            sql.append(" limit ").append(select.getLimitStart()).append(",").append(select.getLimitCount());
        }
        return sql.toString();
    }

    private static String getMysqlPageSql(Page<?> page, StringBuffer sqlBuffer) {
        long offset = (page.getPageNo() - 1L) * page.getPageSize();
        SqlUtil.doWhere(sqlBuffer, page);
        SqlUtil.doCount(sqlBuffer, page);
        sqlBuffer.append(" limit ").append(offset).append(",").append(page.getPageSize());
        return sqlBuffer.toString();
    }

    private static void doWhere(StringBuffer sqlBuffer, Page page) {
        if (!StringUtil.isEmpty((String)page.getWhereWord())) {
            if (sqlBuffer.indexOf("where") == -1) {
                sqlBuffer.append(" where ");
            } else {
                sqlBuffer.append(" and ");
            }
            sqlBuffer.append(page.getWhereWord());
        }
    }

    private static void doCount(StringBuffer stringBuffer, Page page) {
        if (!StringUtil.isEmpty((String)page.getOrderBy())) {
            stringBuffer.append(" order by ").append(page.getOrderBy());
        }
    }

    private static String getCountSql(String sql, Page<?> page) {
        StringBuffer sqlBuffer = new StringBuffer(sql);
        SqlUtil.doWhere(sqlBuffer, page);
        return "select count(1)  as count from (" + sqlBuffer + ") as total";
    }

    private static String getTableName(Base base) {
        return SqlUtil.getTableName(base, null);
    }

    private static String getTableName(Base base, Class cls) {
        if (base != null) {
            String tableName = base.getTableName();
            if (!StringUtil.isEmpty((String)tableName)) {
                return tableName;
            }
            boolean isIndex = false;
            String index = null;
            if (base instanceof ReadBase) {
                ReadBase readBase = (ReadBase)base;
                index = readBase.getIndex();
                isIndex = readBase.isUseIndex();
            }
            return DbWriteService.getInstance().getTableName(base.getTclass(), isIndex, index, base.isUseDataBaseName());
        }
        return DbWriteService.getInstance().getTableName(cls, false, null, false);
    }

    public static String function(String functionName, List<Object> parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append(functionName).append("(");
        if (parameters != null && parameters.size() > 0) {
            for (int i = 0; i < parameters.size(); ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append("?");
            }
        }
        sb.append(")");
        return sb.toString();
    }

    private static String makeInsertToTableSql(Class<?> class1, int createUser, Collection<String> names, HashMap<String, String> systemMap, int isDeleteValue) {
        String tableName = SqlUtil.getTableName(null, class1);
        StringBuilder sql = new StringBuilder().append("insert into ").append(tableName).append("(");
        int nameCount = 0;
        StringBuilder value = new StringBuilder();
        boolean isDelete = false;
        for (String name : names) {
            if (nameCount > 0) {
                sql.append(",");
            }
            sql.append(name);
            String va = systemMap.get(name);
            if (nameCount > 0) {
                value.append(",");
            }
            if (va == null) {
                value.append("?");
            } else if (isDeleteValue != -100 && SystemColumn.Active.getColumn().equals(name)) {
                value.append(isDeleteValue);
                isDelete = true;
            } else {
                value.append(va);
            }
            ++nameCount;
        }
        if (createUser != -1 && ModifyUser.Create.isCreateClass(class1)) {
            sql.append(",").append(ModifyUser.Create.getColumnUser());
            value.append(",").append(createUser);
        }
        if (isDeleteValue != -100 && !isDelete) {
            sql.append(",").append(SystemColumn.Active.getColumn());
            value.append(",").append(isDeleteValue);
        }
        sql.append(") values (");
        sql.append((CharSequence)value);
        sql.append(")");
        return sql.toString();
    }

    private static String makeUpdateToTableSql(String tableName, Collection<String> names, HashMap<String, String> systemMap, boolean isLogUpdate) {
        String time;
        StringBuilder sql = new StringBuilder().append("update ").append(tableName).append(" set ");
        int nameCount = 0;
        for (String name : names) {
            if (nameCount > 0) {
                sql.append(",");
            }
            sql.append(name);
            sql.append("=");
            String va = systemMap.get(name);
            if (va == null) {
                sql.append("?");
            } else {
                sql.append(va);
            }
            ++nameCount;
        }
        if (isLogUpdate && SystemColumn.Modify.isStatus() && sql.indexOf(time = SystemColumn.Modify.getColumn() + "=" + SystemColumn.Modify.getTime()) == -1) {
            sql.append(",").append(time);
        }
        return sql.toString();
    }

    private static String makeUpdateToTableSql(String tableName, HashMap<String, Object> columns, boolean isLogUpdate) {
        StringBuilder sql = new StringBuilder().append("update ").append(tableName).append(" set ");
        SqlUtil.makeUpdateColumns(sql, columns);
        if (isLogUpdate && SystemColumn.Modify.isStatus()) {
            sql.append(",").append(SystemColumn.Modify.getColumn()).append("=").append(SystemColumn.Modify.getTime());
        }
        return sql.toString();
    }

    private static void makeUpdateColumns(StringBuilder sql, HashMap<String, Object> columns) {
        if (columns == null) {
            return;
        }
        int nameCount = 0;
        Iterator<Map.Entry<String, Object>> iterator = columns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            String name = entry.getKey();
            Object obj_value = entry.getValue();
            if (nameCount > 0) {
                sql.append(",");
            }
            sql.append(name);
            sql.append("=");
            String va = SystemColumn.getDefaultValue(name);
            if (va == null) {
                if (SystemColumn.getPwdColumn().equalsIgnoreCase(name)) {
                    sql.append("PASSWORD(?)");
                } else {
                    String value = StringUtil.convertNULL((Object)obj_value);
                    if (value.startsWith("#{") && value.endsWith("}")) {
                        value = value.substring(value.indexOf("#{") + 2, value.indexOf("}"));
                        sql.append(value);
                        iterator.remove();
                    } else {
                        sql.append("?");
                    }
                }
            } else {
                sql.append(va);
            }
            ++nameCount;
        }
    }
}

