/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.sequence;

import cn.jiangzeyin.sequence.ISequence;
import cn.jiangzeyin.system.DbLog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ConcurrentModificationException;
import java.util.concurrent.ConcurrentHashMap;

public class SequenceConfig {
    private static volatile int workerId = -1;
    private static volatile int dataCenterId = -1;
    private static final ConcurrentHashMap<Class<? extends ISequence>, ISequence> I_SEQUENCE_CONCURRENT_HASH_MAP = new ConcurrentHashMap();

    public static void config(int workerId, int dataCenterId) {
        if (workerId <= -1) {
            throw new IllegalArgumentException("workerId<=-1");
        }
        if (dataCenterId <= -1) {
            throw new IllegalArgumentException("dataCenterId<=-1");
        }
        if (SequenceConfig.workerId != -1) {
            throw new ConcurrentModificationException("workerId");
        }
        if (SequenceConfig.dataCenterId != -1) {
            throw new ConcurrentModificationException("dataCenterId");
        }
        SequenceConfig.workerId = workerId;
        SequenceConfig.dataCenterId = dataCenterId;
    }

    public static int getDataCenterId() {
        return dataCenterId;
    }

    public static int getWorkerId() {
        return workerId;
    }

    public static ISequence parseSequence(Class<? extends ISequence> sequence) {
        if (sequence == null) {
            return null;
        }
        if (sequence == ISequence.class) {
            return null;
        }
        return I_SEQUENCE_CONCURRENT_HASH_MAP.computeIfAbsent(sequence, aClass -> {
            try {
                Method method1 = aClass.getMethod("instance", new Class[0]);
                return (ISequence)method1.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                DbLog.getInstance().error("\u83b7\u53d6\u4e3b\u952e\u5bf9\u8c61\u5931\u8d25", e);
                return null;
            }
        });
    }
}

