/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.config;

import cn.jiangzeyin.system.DbLog;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.sql.DataSource;

public final class DatabaseContextHolder {
    private static final ThreadLocal<String> threadLocal = new ThreadLocal();
    private static final Random random = new Random();
    private static Map<String, DataSource>[] MAPS;
    private static String[] tagNames;
    private static DatabaseOptType databaseOptType;
    private static Map<String, DataSource> targetDataSourcesMap;

    private DatabaseContextHolder() {
    }

    public static String getConnectionTagName() {
        return threadLocal.get();
    }

    static void init(Map<String, DataSource>[] maps, String[] tagName) {
        Objects.requireNonNull(maps);
        if (maps.length == 0) {
            throw new IllegalArgumentException("\u6570\u636e\u5e93\u8fde\u63a5\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MAPS = maps;
        tagNames = tagName;
        databaseOptType = maps.length == 1 ? DatabaseOptType.One : (maps.length == 2 ? DatabaseOptType.Two : DatabaseOptType.More);
        targetDataSourcesMap = MAPS[0];
        DbLog.getInstance().info(" \u6570\u636e\u5e93\u64cd\u4f5c\uff1a" + databaseOptType.toString());
    }

    static void init(Map<String, DataSource> map, String tagName) {
        Objects.requireNonNull(map);
        if (map.size() < 1) {
            throw new RuntimeException("\u6570\u636e\u5e93\u8fde\u63a5\u52a0\u8f7d\u4e3a\u7a7a");
        }
        targetDataSourcesMap = map;
        tagNames = new String[]{tagName};
        DbLog.getInstance().info(" \u6570\u636e\u5e93\u64cd\u4f5c\uff1a" + databaseOptType.toString());
    }

    private static Map<String, DataSource> randMap() {
        int index = random.nextInt(MAPS.length);
        threadLocal.set(tagNames[index]);
        return MAPS[index];
    }

    public static DataSource getReadDataSource(String tag) {
        DataSource dataSource = null;
        if (databaseOptType == DatabaseOptType.One) {
            dataSource = targetDataSourcesMap.get(tag);
            threadLocal.set(tagNames[0]);
        } else if (databaseOptType == DatabaseOptType.Two) {
            dataSource = MAPS[1].get(tag);
            threadLocal.set(tagNames[1]);
        } else if (databaseOptType == DatabaseOptType.More) {
            dataSource = DatabaseContextHolder.randMap().get(tag);
        }
        Objects.requireNonNull(dataSource, "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6570\u636e\u6e90\uff1a" + tag);
        return dataSource;
    }

    public static DataSource getWriteDataSource(String tag) {
        DataSource dataSource = null;
        if (databaseOptType == DatabaseOptType.One) {
            dataSource = targetDataSourcesMap.get(tag);
            threadLocal.set(tagNames[0]);
        } else if (databaseOptType == DatabaseOptType.Two) {
            dataSource = targetDataSourcesMap.get(tag);
            threadLocal.set(tagNames[0]);
        } else if (databaseOptType == DatabaseOptType.More) {
            dataSource = DatabaseContextHolder.randMap().get(tag);
        }
        Objects.requireNonNull(dataSource, "\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u6570\u636e\u6e90\uff1a" + tag);
        return dataSource;
    }

    public static Connection getWriteConnection(String tag) throws SQLException {
        return DatabaseContextHolder.getWriteDataSource(tag).getConnection();
    }

    static {
        databaseOptType = DatabaseOptType.One;
    }

    public static enum DatabaseOptType {
        One,
        Two,
        More;

    }
}

