/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.sequence;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.SystemClock;
import cn.jiangzeyin.sequence.ISequence;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;

public abstract class BaseSequence
implements ISequence {
    protected final int workerId;
    protected final int dataCenterId;
    protected final long sequenceMask;
    protected final int workerIdShift;
    protected final int dataCenterIdShift;
    protected final int workerIdBits;
    protected final int dataCenterIdBits;
    protected final int sequenceBits;
    protected long sequence = 0L;
    protected long lastTimestamp = -1L;

    public BaseSequence(int workerId, int dataCenterId, int workerIdBits, int dataCenterIdBits, int sequenceBits) {
        if (workerIdBits <= 0) {
            throw new IllegalArgumentException("workerIdBits");
        }
        this.workerIdBits = workerIdBits;
        if (dataCenterIdBits <= 0) {
            throw new IllegalArgumentException("dataCenterIdBits");
        }
        this.dataCenterIdBits = dataCenterIdBits;
        long maxDataCenterId = 0xFFFFFFFFFFFFFFFFL ^ -1L << dataCenterIdBits;
        if (dataCenterId < 0) {
            dataCenterId = (int)BaseSequence.getDataCenterId(maxDataCenterId);
        }
        if ((long)dataCenterId > maxDataCenterId || dataCenterId < 0) {
            throw new IllegalArgumentException(String.format("dataCenter Id can't be greater than %d or less than 0", maxDataCenterId));
        }
        long maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << workerIdBits;
        if (workerId < 0) {
            workerId = (int)BaseSequence.getWorkerId(dataCenterId, maxWorkerId);
        }
        if ((long)workerId > maxWorkerId || workerId < 0) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", maxWorkerId));
        }
        this.dataCenterId = dataCenterId;
        this.workerId = workerId;
        if (sequenceBits <= 0) {
            throw new IllegalArgumentException("sequenceBits");
        }
        this.sequenceBits = sequenceBits;
        this.workerIdShift = sequenceBits;
        this.dataCenterIdShift = sequenceBits + workerIdBits;
        this.sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << sequenceBits;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    protected long timeGen() {
        return SystemClock.now();
    }

    private static long getWorkerId(long dataCenterId, long maxWorkerId) {
        StringBuilder mpid = new StringBuilder();
        mpid.append(dataCenterId);
        String name = ManagementFactory.getRuntimeMXBean().getName();
        if (!StringUtil.isEmpty((String)name)) {
            mpid.append(name.split("@")[0]);
        }
        return (long)(mpid.toString().hashCode() & 0xFFFF) % (maxWorkerId + 1L);
    }

    private static long getDataCenterId(long maxDataCenterId) {
        long id = 0L;
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            if (network == null) {
                id = 1L;
            } else {
                byte[] mac = network.getHardwareAddress();
                if (null != mac) {
                    id = (0xFFL & (long)mac[mac.length - 1] | 0xFF00L & (long)mac[mac.length - 2] << 8) >> 6;
                    id %= maxDataCenterId + 1L;
                }
            }
        }
        catch (Exception e) {
            System.err.println(" getDatacenterId: " + e.getMessage());
        }
        return id;
    }
}

