/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class DbReflectUtil {
    public static Object getFieldValue(Object obj, String fieldName) throws IllegalAccessException {
        Objects.requireNonNull(obj);
        Field field = DbReflectUtil.getField(obj.getClass(), fieldName);
        return field.get(obj);
    }

    public static List<Field> getDeclaredFields(Class<?> cls) {
        String key = cls.getName() + "_DeclaredFields";
        Object object = ReflectCache.get(key);
        if (object instanceof List) {
            return (List)object;
        }
        Map<String, Field> map = DbReflectUtil.getFieldMap(cls);
        ArrayList<Field> fieldList = new ArrayList<Field>(map.values());
        ReflectCache.put(key, fieldList);
        return fieldList;
    }

    private static Map<String, Field> getFieldMap(Class<?> cls) {
        String key = cls.getName() + "_DeclaredFields_Map";
        Object object = ReflectCache.get(key);
        if (object instanceof List) {
            return (Map)object;
        }
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Class<?> clazz = cls; clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field item : clazz.getDeclaredFields()) {
                String name = item.getName().toLowerCase();
                if (map.containsKey(name)) continue;
                item.setAccessible(true);
                map.put(name, item);
            }
        }
        ReflectCache.put(key, map);
        return map;
    }

    public static Field getField(Class<?> cls, String fieldName) {
        Objects.requireNonNull(fieldName);
        Map<String, Field> map = DbReflectUtil.getFieldMap(cls);
        return map.get(fieldName.toLowerCase());
    }

    public static void setFieldValue(Object obj, String fieldName, Object fieldValue) throws IllegalAccessException {
        Field field = DbReflectUtil.getField(obj.getClass(), fieldName);
        Class<?> type = field.getType();
        if (fieldValue == null) {
            field.set(obj, null);
            return;
        }
        fieldValue = DbReflectUtil.convertType(fieldValue, type);
        field.set(obj, fieldValue);
    }

    public static Object convertType(Object object, Class needType) {
        if (object == null) {
            return null;
        }
        if (object.getClass() == needType) {
            return object;
        }
        if (needType == Integer.TYPE || needType == Integer.class) {
            return Integer.valueOf(String.valueOf(object));
        }
        if (needType == Long.TYPE || needType == Long.class) {
            return Long.valueOf(String.valueOf(object));
        }
        if (needType == Double.TYPE || needType == Double.class) {
            return Double.valueOf(String.valueOf(object));
        }
        if (needType == Float.TYPE || needType == Float.class) {
            return Float.valueOf(String.valueOf(object));
        }
        if (needType == BigDecimal.class) {
            return BigDecimal.valueOf(Long.valueOf(String.valueOf(object)));
        }
        if (needType == Short.class || Short.TYPE == needType) {
            return Short.valueOf(String.valueOf(object));
        }
        if (needType == Boolean.TYPE || Boolean.class == needType) {
            return Boolean.valueOf(String.valueOf(object));
        }
        return object;
    }

    public static Class<?> getTClass(Class<?> cls) {
        Type type = cls.getGenericSuperclass();
        if (type instanceof ParameterizedType) {
            type = ((ParameterizedType)type).getActualTypeArguments()[0];
            return (Class)type;
        }
        return null;
    }

    public static List<Method> getAllSetMethods(Class cls) {
        return DbReflectUtil.getAllMethods(cls, "set");
    }

    private static List<Method> getAllMethods(Class cls, String prefix) {
        Objects.requireNonNull(cls);
        String key = cls.getName() + "_" + prefix;
        Object object = ReflectCache.get(key);
        if (object instanceof List) {
            return (List)object;
        }
        ArrayList<Method> list = new ArrayList<Method>();
        for (Class clazz = cls; clazz != Object.class; clazz = clazz.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = clazz.getDeclaredMethods()) {
                if (!method.getName().startsWith(prefix)) continue;
                list.add(method);
            }
        }
        ReflectCache.put(key, list);
        return list;
    }

    private static final class ReflectCache {
        private static final ConcurrentHashMap<String, Object> CACHE = new ConcurrentHashMap();

        private ReflectCache() {
        }

        static void put(String key, Object object) {
            CACHE.put(key, object);
        }

        static Object get(String key) {
            return CACHE.get(key);
        }
    }
}

