/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.run.write;

import cn.jiangzeyin.database.DbWriteService;
import cn.jiangzeyin.database.base.WriteBase;
import cn.jiangzeyin.database.config.DatabaseContextHolder;
import cn.jiangzeyin.database.config.SystemColumn;
import cn.jiangzeyin.database.util.SqlUtil;
import cn.jiangzeyin.system.DBExecutorService;
import cn.jiangzeyin.system.DbLog;
import com.alibaba.druid.util.JdbcUtils;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;

public class Remove<T>
extends WriteBase<T> {
    private String ids;
    private String where;
    private List<Object> parameters;
    private Type type;
    private HashMap<String, Object> update;

    public Remove(Connection transactionConnection) {
        super(transactionConnection);
        this.setThrows(true);
    }

    public Remove setUpdate(HashMap<String, Object> update) {
        this.checkUpdate();
        Remove.checkUpdate(this.getTclass(), update);
        this.update = update;
        return this;
    }

    public Remove putUpdate(String column, Object value) {
        this.checkUpdate();
        if (SystemColumn.notCanUpdate(column)) {
            throw new IllegalArgumentException(column + " not update");
        }
        if (SystemColumn.isSequence(this.getTclass(), column)) {
            throw new IllegalArgumentException(column + " not update sequence");
        }
        if (this.update == null) {
            this.update = new HashMap();
        }
        this.update.put(column, value);
        return this;
    }

    private void checkUpdate() {
        if (this.type == Type.delete) {
            throw new IllegalArgumentException("type error " + (Object)((Object)Type.delete));
        }
    }

    public Remove setType(Type type) {
        this.type = type;
        return this;
    }

    public HashMap<String, Object> getUpdate() {
        return this.update;
    }

    public Type getType() {
        return this.type;
    }

    public Remove(Type type) {
        this(type, false);
    }

    public Remove(Type type, boolean isThrows) {
        this.type = type;
        this.setThrows(isThrows);
        if (-100 == SystemColumn.Active.getActiveValue() && type != Type.delete) {
            throw new IllegalArgumentException("please set systemColumn.active");
        }
    }

    public List<Object> getParameters() {
        if (this.parameters == null) {
            return new ArrayList<Object>();
        }
        return this.parameters;
    }

    public Remove setParameters(List<Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Remove setParameters(Object ... parameters) {
        if (this.parameters == null) {
            this.parameters = new LinkedList<Object>();
        }
        Collections.addAll(this.parameters, parameters);
        return this;
    }

    public String getIds() {
        return this.ids;
    }

    public void setIds(String ids) {
        this.ids = ids;
    }

    public void setIds(int id) {
        this.ids = String.valueOf(id);
    }

    public String getWhere() {
        return this.where;
    }

    public Remove setWhere(String where) {
        this.where = where;
        return this;
    }

    @Override
    public void run() {
        if (this.transactionConnection != null) {
            throw new RuntimeException("Transaction must sync");
        }
        this.setAsync();
        this.getAsyncLog();
        this.setThrowable(new Throwable());
        DBExecutorService.execute(this::syncRun);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int syncRun() {
        if (this.type == null) {
            throw new IllegalArgumentException("type null");
        }
        try {
            int up;
            WriteBase.Callback callback = this.getCallback();
            String tag = DbWriteService.getInstance().getDatabaseName(this.getTclass());
            String sql = SqlUtil.getRemoveSql(this);
            DbLog.getInstance().info(this.getTransferLog() + sql);
            this.setRunSql(sql);
            if (this.transactionConnection != null) {
                up = JdbcUtils.executeUpdate((Connection)this.transactionConnection, (String)sql, this.getParameters());
            } else {
                DataSource dataSource = DatabaseContextHolder.getWriteDataSource(tag);
                up = JdbcUtils.executeUpdate((DataSource)dataSource, (String)sql, this.getParameters());
            }
            if (up > 0 && callback != null) {
                callback.success(up);
            }
            int n = up;
            return n;
        }
        catch (Exception e) {
            this.isThrows(e);
        }
        finally {
            this.runEnd();
            this.recycling();
            this.parameters = null;
            this.ids = null;
            this.where = null;
        }
        return 0;
    }

    public static enum Type {
        delete,
        recovery,
        remove;

    }
}

