/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.util;

import cn.jiangzeyin.database.base.ReadBase;
import cn.jiangzeyin.database.config.DatabaseContextHolder;
import cn.jiangzeyin.database.config.SystemColumn;
import cn.jiangzeyin.database.util.SqlUtil;
import cn.jiangzeyin.system.DbLog;
import cn.jiangzeyin.util.DbReflectUtil;
import cn.jiangzeyin.util.KeyMap;
import com.alibaba.druid.util.JdbcUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;

public class Util {
    public static <T> List<T> convertList(ReadBase<T> reBase, List<Map<String, Object>> list) throws Exception {
        Objects.requireNonNull(list, "list map");
        Objects.requireNonNull(reBase, "reBase");
        ArrayList<T> listR = new ArrayList<T>();
        for (Map<String, Object> t : list) {
            listR.add(Util.convertMap(reBase, t, null));
        }
        return listR;
    }

    private static <T> T convertMap(ReadBase<T> read, Map<String, Object> map, Class<?> refClass) throws Exception {
        if (refClass == null) {
            refClass = read.getTclass();
        }
        Object obj = refClass.newInstance();
        KeyMap<String, Object> keyMap = new KeyMap<String, Object>(map);
        HashMap<String, Class<?>> refMap = read.getRefMap();
        HashMap<String, String> refWhere = read.getRefWhere();
        List<String> remove = read.getRemove();
        List<Method> methods = DbReflectUtil.getAllSetMethods(obj.getClass());
        DataSource dataSource = DatabaseContextHolder.getReadDataSource(read.getTag());
        for (Method method : methods) {
            Object value;
            String name = method.getName();
            if (!name.startsWith("set")) continue;
            name = name.substring(3).toLowerCase();
            if (remove != null && remove.contains(name) || SystemColumn.isReadRemove(name) || (value = keyMap.get(name)) == null) continue;
            if (refMap != null && refMap.containsKey(name)) {
                String where = refWhere == null ? null : refWhere.get(name);
                Class<?> refMapClass = refMap.get(name);
                String sql = SqlUtil.getRefSql(refMapClass, read.getRefKey(), where);
                DbLog.getInstance().info(sql);
                ArrayList<Object> parameters = new ArrayList<Object>();
                parameters.add(value);
                List refList = JdbcUtils.executeQuery((DataSource)dataSource, (String)sql, parameters);
                if (refList == null || refList.size() <= 0) continue;
                Map refMap_data = (Map)refList.get(0);
                T refValue = Util.convertMap(read, refMap_data, refMapClass);
                try {
                    method.invoke(obj, refValue);
                }
                catch (IllegalArgumentException e) {
                    DbLog.getInstance().error(String.format(obj.getClass() + " map\u8f6c\u5b9e\u4f53%s\u5b57\u6bb5\u9519\u8bef\uff1a%s -> %s", name, value.getClass(), value), e);
                }
                continue;
            }
            Class<?>[] classes = method.getParameterTypes();
            if (classes == null || classes.length != 1) {
                throw new IllegalArgumentException(method + " \u4e0d\u7b26\u5408\u89c4\u8303");
            }
            Class<?> pClass = classes[0];
            value = DbReflectUtil.convertType(value, pClass);
            try {
                method.invoke(obj, value);
            }
            catch (Exception e) {
                DbLog.getInstance().error(String.format(obj.getClass() + " map\u8f6c\u5b9e\u4f53%s\u5b57\u6bb5\u9519\u8bef\uff1a%s -> %s  %s", name, value.getClass(), value, pClass), e);
            }
        }
        return (T)obj;
    }
}

