/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.database.base;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.database.config.DataSourceConfig;
import cn.jiangzeyin.database.config.DatabaseContextHolder;
import cn.jiangzeyin.database.config.SystemColumn;
import cn.jiangzeyin.system.DbLog;
import cn.jiangzeyin.system.SystemSessionInfo;
import cn.jiangzeyin.util.DbReflectUtil;
import com.alibaba.druid.util.StringUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public abstract class Base<T> {
    private boolean isThrows;
    private HashMap<String, Class<?>> refMap;
    private HashMap<String, String> refWhere;
    private String refKey;
    private List<String> remove;
    private String tag;
    private Class<?> tclass;
    private int optUserId;
    private long runTime;
    private String runSql;
    private String tempTransferLog;
    private String tagName;
    private String tableName;
    private boolean useDataBaseName;

    public boolean isUseDataBaseName() {
        return this.useDataBaseName;
    }

    public void setUseDataBaseName(boolean useDataBaseName) {
        this.useDataBaseName = useDataBaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    private String getTagName() {
        if (this.tagName == null) {
            return DatabaseContextHolder.getConnectionTagName();
        }
        return this.tagName;
    }

    private void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public HashMap<String, String> getRefWhere() {
        return this.refWhere;
    }

    Base() {
        this.setOptUserId(SystemSessionInfo.getUserId());
        this.runTime = System.currentTimeMillis();
    }

    protected void setRunSql(String runSql) {
        this.runSql = runSql;
    }

    protected void runEnd() {
        long time = System.currentTimeMillis() - this.runTime;
        if (time > 2000L) {
            String tagName = this.getTagName();
            DbLog.getInstance().warn(tagName + "\u6267\u884c\u65f6\u95f4\u8fc7\u957f\uff1a" + time + "  " + this.runSql);
        }
    }

    public int getOptUserId() {
        return this.optUserId;
    }

    public void setOptUserId(int optUserId) {
        this.optUserId = optUserId;
    }

    public Class<?> getTclass() {
        return this.getTclass(true);
    }

    public Class<?> getTclass(boolean getRef) {
        if (this.tclass == null && getRef) {
            this.tclass = DbReflectUtil.getTClass(this.getClass());
        }
        return this.tclass;
    }

    public void setTclass(Class<?> tclass) {
        this.tclass = tclass;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public List<String> getRemove() {
        return this.remove;
    }

    public void setRemove(String ... remove) {
        if (remove == null) {
            return;
        }
        if (this.remove == null) {
            this.remove = new LinkedList<String>();
        }
        for (String item : remove) {
            if (this.remove.contains(item)) continue;
            this.remove.add(item.toLowerCase());
        }
    }

    public String getRefKey() {
        if (StringUtils.isEmpty((String)this.refKey)) {
            return SystemColumn.getDefaultRefKeyName();
        }
        return this.refKey;
    }

    public void setRefKey(String refKey) {
        this.refKey = refKey;
    }

    public HashMap<String, Class<?>> getRefMap() {
        return this.refMap;
    }

    public void putRefClass(String name, Class<?> refClass) {
        if (this.refMap == null) {
            this.refMap = new HashMap();
        }
        this.refMap.put(name.toLowerCase(), refClass);
    }

    public void putRefClass(String name, Class<?> refClass, String where) {
        if (this.refMap == null) {
            this.refMap = new HashMap();
        }
        if (this.refWhere == null) {
            this.refWhere = new HashMap();
        }
        this.refMap.put(name, refClass);
        this.refWhere.put(name, where);
    }

    public boolean isThrows() {
        return this.isThrows;
    }

    public void setThrows(boolean isThrows) {
        this.isThrows = isThrows;
    }

    public void isThrows(Throwable t) {
        if (this.isThrows) {
            throw new RuntimeException(t);
        }
        DbLog.getInstance().error("\u6267\u884c\u6570\u636e\u5e93\u64cd\u4f5c", t);
    }

    protected void recycling() {
        this.refMap = null;
        this.refKey = null;
        this.refWhere = null;
        this.remove = null;
        this.tag = null;
        this.tclass = null;
        this.optUserId = 0;
        this.runSql = null;
        this.runTime = 0L;
        this.tagName = null;
        DatabaseContextHolder.recycling();
    }

    protected String getTransferLog() {
        if (this.tempTransferLog != null) {
            return this.tempTransferLog;
        }
        return DataSourceConfig.isActive() ? "" : this.getLine();
    }

    private String getLine() {
        StackTraceElement stackTraceElement = Thread.currentThread().getStackTrace()[4];
        return String.format("[%s-%s-%s]", StringUtil.simplifyClassName((String)stackTraceElement.getClassName()), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber());
    }

    protected void getAsyncLog() {
        this.tempTransferLog = this.getLine();
        this.setTagName(DatabaseContextHolder.getConnectionTagName());
    }
}

