/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.cache;

import cn.jiangzeyin.cache.CacheInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class ObjectCache {
    private static final ConcurrentHashMap<String, CacheEntity<String, Object>> CONCURRENT_HASH_MAP = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, CacheInfo> CACHE_INFO_CONCURRENT_HASH_MAP = new ConcurrentHashMap();
    public static final int DEFAULT_CACHE_TIME = 600;

    private ObjectCache() {
    }

    public static void config(Class cls) throws IllegalAccessException {
        CACHE_INFO_CONCURRENT_HASH_MAP.putAll(CacheInfo.loadClass(cls));
    }

    public static Object put(String key, Object value) {
        return ObjectCache.put(key, value, -1L);
    }

    public static Object put(String key, Object value, long cacheTime) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        if (cacheTime < -1L) {
            throw new IllegalArgumentException("cacheTime must >=0");
        }
        CacheEntity<String, Object> cacheEntity = CONCURRENT_HASH_MAP.get(key);
        if (cacheEntity == null) {
            CacheInfo cacheInfo = CACHE_INFO_CONCURRENT_HASH_MAP.get(key);
            if (cacheInfo == null) {
                cacheInfo = new CacheInfo(key, cacheTime == -1L ? 600L : cacheTime);
                CACHE_INFO_CONCURRENT_HASH_MAP.put(cacheInfo.getKey(), cacheInfo);
            } else if (cacheTime != -1L) {
                cacheInfo.setCacheTime(cacheTime);
            }
            cacheEntity = new CacheEntity<String, Object>(key, value, cacheInfo);
            CONCURRENT_HASH_MAP.put(cacheEntity.getKey(), cacheEntity);
            return null;
        }
        return cacheEntity.setValue(value, cacheTime);
    }

    public static Object get(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        CacheEntity<String, Object> cacheEntity = CONCURRENT_HASH_MAP.get(key);
        return cacheEntity == null ? null : cacheEntity.getValue();
    }

    private static long getCurrentTime() {
        return System.currentTimeMillis() / 1000L;
    }

    private static class CacheEntity<K, V>
    implements Map.Entry<K, V> {
        final K key;
        final CacheInfo cacheInfo;
        V value;
        long intoTime;

        CacheEntity(K key, V value, CacheInfo cacheInfo) {
            this.key = key;
            this.value = value;
            this.intoTime = ObjectCache.getCurrentTime();
            this.cacheInfo = cacheInfo;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            long existTime = ObjectCache.getCurrentTime() - this.intoTime;
            if (existTime > this.cacheInfo.getCacheTime()) {
                return null;
            }
            return this.value;
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            V val = this.value;
            this.value = value;
            this.intoTime = ObjectCache.getCurrentTime();
            return val;
        }

        V setValue(V value, long cacheTime) {
            if (cacheTime != -1L) {
                this.cacheInfo.setCacheTime(cacheTime);
            }
            return this.setValue(value);
        }
    }
}

