/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.interceptor;

import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.controller.base.AbstractBaseControl;
import cn.jiangzeyin.controller.base.AbstractMultipartFileBaseControl;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.http.HttpStatus;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public abstract class BaseInterceptor
extends HandlerInterceptorAdapter {
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected HttpSession session;
    protected ServletContext application;
    protected String url;
    private AbstractBaseControl abstractBaseControl;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        this.session = request.getSession();
        this.application = this.session.getServletContext();
        this.request = request;
        this.response = response;
        this.url = request.getRequestURI();
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Class<?> controlClass = ((HandlerMethod)handler).getBean().getClass();
            Object object = handlerMethod.getBean();
            if (AbstractMultipartFileBaseControl.class.isAssignableFrom(controlClass)) {
                AbstractMultipartFileBaseControl abstractMultipartFileBaseControl = (AbstractMultipartFileBaseControl)object;
                abstractMultipartFileBaseControl.setReqAndRes(this.request, this.session, this.response);
                this.abstractBaseControl = abstractMultipartFileBaseControl;
            } else if (AbstractBaseControl.class.isAssignableFrom(controlClass)) {
                this.abstractBaseControl = (AbstractBaseControl)object;
                this.abstractBaseControl.setReqAndRes(this.request, this.session, this.response);
            }
        }
        return true;
    }

    protected void reload() {
        if (this.abstractBaseControl != null) {
            this.abstractBaseControl.reLoad();
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (response.getStatus() != HttpStatus.OK.value()) {
            DefaultSystemLog.LOG().info("\u8bf7\u6c42\u9519\u8bef:" + request.getRequestURI() + "  " + response.getStatus());
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (ex != null) {
            DefaultSystemLog.ERROR().error("controller \u5f02\u5e38:" + request.getRequestURL(), (Throwable)ex);
        }
    }
}

