/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.controller.base;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.spring.SpringUtil;
import cn.jiangzeyin.controller.base.RequestUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class AbstractBaseControl {
    private static final ThreadLocal<HttpServletRequest> HTTP_SERVLET_REQUEST_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<HttpSession> HTTP_SESSION_THREAD_LOCAL = new ThreadLocal();
    private static final ThreadLocal<HttpServletResponse> HTTP_SERVLET_RESPONSE_THREAD_LOCAL = new ThreadLocal();
    protected String ip;
    private static String default_headerName;

    public void setReqAndRes(HttpServletRequest request, HttpSession session, HttpServletResponse response) {
        HTTP_SERVLET_REQUEST_THREAD_LOCAL.set(request);
        HTTP_SESSION_THREAD_LOCAL.set(session);
        HTTP_SERVLET_RESPONSE_THREAD_LOCAL.set(response);
        this.ip = AbstractBaseControl.getIpAddress(request);
        response.setCharacterEncoding("UTF-8");
    }

    public void reLoad() {
    }

    protected HttpServletResponse getResponse() {
        HttpServletResponse response = HTTP_SERVLET_RESPONSE_THREAD_LOCAL.get();
        if (response == null) {
            ServletRequestAttributes requestAttributes = AbstractBaseControl.getRequestAttributes();
            if (requestAttributes == null) {
                return null;
            }
            response = requestAttributes.getResponse();
        }
        return response;
    }

    private static ServletRequestAttributes getRequestAttributes() {
        RequestAttributes attributes;
        try {
            attributes = RequestContextHolder.currentRequestAttributes();
        }
        catch (IllegalStateException e) {
            DefaultSystemLog.ERROR().error("\u83b7\u53d6req\u5931\u8d25", (Throwable)e);
            return null;
        }
        return (ServletRequestAttributes)attributes;
    }

    protected HttpSession getSession() {
        HttpServletRequest request;
        HttpSession session = HTTP_SESSION_THREAD_LOCAL.get();
        if (session == null && (request = this.getRequest()) != null) {
            session = request.getSession();
        }
        return session;
    }

    protected HttpServletRequest getRequest() {
        HttpServletRequest request = HTTP_SERVLET_REQUEST_THREAD_LOCAL.get();
        if (request == null) {
            ServletRequestAttributes sra = AbstractBaseControl.getRequestAttributes();
            if (sra == null) {
                return null;
            }
            request = sra.getRequest();
        }
        return request;
    }

    protected Object getAttribute(String name) {
        return this.getRequest().getAttribute(name);
    }

    protected void setAttribute(String name, Object object) {
        this.getRequest().setAttribute(name, object);
    }

    protected String getHeader(String name) {
        return this.getRequest().getHeader(name);
    }

    protected String getSessionAttribute(String name) {
        return StringUtil.convertNULL((Object)this.getSessionAttributeObj(name));
    }

    protected Object getSessionAttributeObj(String name) {
        return this.getSession().getAttribute(name);
    }

    protected void removeSessionAttribute(String name) {
        this.getSession().removeAttribute(name);
    }

    protected void setSessionAttribute(String name, Object object) {
        this.getSession().setAttribute(name, object);
    }

    protected String getCookieValue(String name) {
        Cookie cookie = RequestUtil.getCookieByName(this.getRequest(), name);
        if (cookie == null) {
            return "";
        }
        return cookie.getValue();
    }

    protected String getParameter(String name) {
        return this.getParameter(name, null);
    }

    protected String[] getParameters(String name) {
        return this.getRequest().getParameterValues(name);
    }

    protected String getParameter(String name, String def) {
        String value = this.getRequest().getParameter(name);
        return value == null ? def : value;
    }

    protected int getParameterInt(String name, int def) {
        return StringUtil.parseInt((String)this.getParameter(name), (int)def);
    }

    protected int getParameterInt(String name) {
        return this.getParameterInt(name, 0);
    }

    protected Map<String, String> getRefererParameter() throws UnsupportedEncodingException {
        String referer = this.getHeader("Referer");
        return RequestUtil.convertUrlMap(referer);
    }

    protected <T> T getObject(Class<T> tClass) throws IllegalAccessException, InstantiationException {
        T obj = tClass.newInstance();
        this.doParameterMap(this.getRequest().getParameterMap(), obj);
        return obj;
    }

    void doParameterMap(Map<String, String[]> parameter, Object obj) {
        Iterator<Map.Entry<String, String[]>> entries = parameter.entrySet().iterator();
        Class<?> tClass = obj.getClass();
        while (entries.hasNext()) {
            Map.Entry<String, String[]> entry = entries.next();
            String key = entry.getKey();
            String[] value = entry.getValue();
            if (value == null) continue;
            String[] temp = value;
            StringBuilder stringBuffer = new StringBuilder();
            for (int i = 0; i < temp.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(temp[i]);
            }
            this.setValue(tClass, obj, key, stringBuffer.toString());
        }
    }

    private void setValue(Class tClass, Object obj, String name, String value) {
        Field[] fields = tClass.getDeclaredFields();
        Class<?> type = null;
        for (Field field : fields) {
            if (!field.getName().equals(name)) continue;
            type = field.getType();
            break;
        }
        if (type == null) {
            Class superClass = tClass.getSuperclass();
            if (superClass != Object.class) {
                this.setValue(superClass, obj, name, value);
            }
            return;
        }
        try {
            Method method = AbstractBaseControl.getMethod(tClass, name, type);
            if (type == Integer.TYPE || type == Integer.class) {
                method.invoke(obj, Integer.valueOf(value));
            } else if (type == Long.TYPE || type == Long.class) {
                method.invoke(obj, Long.valueOf(value));
            } else if (type == String.class) {
                method.invoke(obj, value);
            } else if (type == BigDecimal.class) {
                method.invoke(obj, BigDecimal.valueOf(Long.parseLong(value)));
            } else if (type == Float.TYPE || type == Float.class) {
                method.invoke(obj, Float.valueOf(value));
            } else if (AbstractBaseControl.class.isAssignableFrom(type)) {
                Object type_obj = type.newInstance();
                Method setIdMethod = AbstractBaseControl.getMethod(type_obj.getClass(), "Id", Integer.class);
                try {
                    setIdMethod.invoke(type_obj, Integer.valueOf(value));
                    method.invoke(obj, type_obj);
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (type == Double.class || type == Double.TYPE) {
                method.invoke(obj, Double.valueOf(value));
            } else {
                DefaultSystemLog.ERROR().error("\u672a\u8bbe\u7f6e\u5bf9\u5e94\u6570\u636e\u7c7b\u578b:" + type, (Throwable)new RuntimeException());
            }
        }
        catch (Exception e) {
            DefaultSystemLog.ERROR().error("\u521b\u5efa\u5bf9\u8c61\u9519\u8bef", (Throwable)e);
        }
    }

    private static Method getMethod(Class<?> tClass, String name, Class type) throws NoSuchMethodException {
        try {
            return tClass.getDeclaredMethod(AbstractBaseControl.parSetName(name), type);
        }
        catch (NoSuchMethodException e) {
            Class<?> superClass = tClass.getSuperclass();
            if (superClass != Object.class) {
                return AbstractBaseControl.getMethod(superClass, name, type);
            }
            throw e;
        }
    }

    private static String parSetName(String fieldName) {
        if (null == fieldName || "".equals(fieldName)) {
            return null;
        }
        int startIndex = 0;
        if (fieldName.charAt(0) == '_') {
            startIndex = 1;
        }
        return "set" + fieldName.substring(startIndex, startIndex + 1).toUpperCase() + fieldName.substring(startIndex + 1);
    }

    public static String getIpAddress(HttpServletRequest request) {
        if (default_headerName == null) {
            default_headerName = SpringUtil.getEnvironment().getProperty("ip.defaultHeaderName");
        }
        String ipFromNginx = null;
        if (!StringUtil.isEmpty((String)default_headerName)) {
            ipFromNginx = request.getHeader(default_headerName);
        }
        if (ipFromNginx != null && ipFromNginx.length() > 0) {
            return ipFromNginx;
        }
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        ip = StringUtil.convertNULL((String)ip);
        return ip;
    }
}

