/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.interceptor;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.SpringApplicationBuilder;
import cn.jiangzeyin.common.interceptor.BaseInterceptor;
import cn.jiangzeyin.common.interceptor.DefaultInterceptor;
import cn.jiangzeyin.common.interceptor.InterceptorPattens;
import cn.jiangzeyin.common.spring.SpringUtil;
import cn.jiangzeyin.util.PackageUtil;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableWebMvc
public class InterceptorControl
extends WebMvcConfigurerAdapter {
    @Value(value="${interceptor.initPackageName:}")
    private String loadPath;
    private boolean isHash = false;
    private static final List<Class> LOAD_OK = new ArrayList<Class>();

    public void addInterceptors(InterceptorRegistry registry) {
        this.init(registry);
    }

    private void init(InterceptorRegistry registry) {
        List<String> list;
        if (this.loadPath == null || this.loadPath.length() <= 0) {
            this.loadDefault(registry);
            return;
        }
        try {
            list = PackageUtil.getClassName(this.loadPath);
        }
        catch (IOException e) {
            DefaultSystemLog.ERROR().error("\u52a0\u8f7d\u62e6\u622a\u5668\u5f02\u5e38", (Throwable)e);
            this.loadDefault(registry);
            return;
        }
        if (list.size() <= 0) {
            this.loadDefault(registry);
            return;
        }
        for (String item : list) {
            boolean isAbstract;
            Class<?> classItem;
            try {
                classItem = Class.forName(item);
            }
            catch (ClassNotFoundException e) {
                DefaultSystemLog.ERROR().error("\u52a0\u8f7d\u62e6\u622a\u5668\u9519\u8bef", (Throwable)e);
                continue;
            }
            if (classItem == null || classItem == DefaultInterceptor.class || (isAbstract = Modifier.isAbstract(classItem.getModifiers())) || !BaseInterceptor.class.isAssignableFrom(classItem)) continue;
            this.loadInterceptor(classItem, registry);
        }
        this.loadDefault(registry);
    }

    private void loadApplicationInterceptor(InterceptorRegistry registry) {
        List<Class<? extends BaseInterceptor>> interceptorClass = SpringApplicationBuilder.getInstance().getInterceptorClass();
        if (interceptorClass != null) {
            for (Class<? extends BaseInterceptor> item : interceptorClass) {
                this.loadInterceptor(item, registry);
            }
        }
    }

    private void loadDefault(InterceptorRegistry registry) {
        if (this.isHash) {
            this.loadApplicationInterceptor(registry);
            return;
        }
        this.loadApplicationInterceptor(registry);
        DefaultSystemLog.LOG().info("\u52a0\u8f7d\u9ed8\u8ba4\u62e6\u622a\u5668");
        this.loadInterceptor(DefaultInterceptor.class, registry);
    }

    private void loadInterceptor(Class itemCls, InterceptorRegistry registry) {
        BaseInterceptor handlerInterceptor;
        if (LOAD_OK.contains(itemCls)) {
            DefaultSystemLog.LOG().info("\u91cd\u590d\u6ce8\u5165\u62e6\u622a\u5668" + itemCls);
            return;
        }
        InterceptorPattens interceptorPattens = itemCls.getAnnotation(InterceptorPattens.class);
        if (interceptorPattens == null) {
            return;
        }
        try {
            handlerInterceptor = (BaseInterceptor)((Object)itemCls.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            DefaultSystemLog.ERROR().error("\u52a0\u8f7d\u62e6\u622a\u5668\u9519\u8bef", (Throwable)e);
            return;
        }
        Object[] patterns = interceptorPattens.value();
        InterceptorRegistration registration = registry.addInterceptor((HandlerInterceptor)handlerInterceptor);
        registration.addPathPatterns((String[])patterns);
        Object[] exclude = interceptorPattens.exclude();
        if (exclude.length > 0) {
            registration.excludePathPatterns((String[])exclude);
        }
        LOAD_OK.add(itemCls);
        DefaultSystemLog.LOG().info("\u52a0\u8f7d\u62e6\u622a\u5668\uff1a" + itemCls + "  " + Arrays.toString(patterns) + "  " + Arrays.toString(exclude));
        this.isHash = true;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String resourceHandler = SpringUtil.getEnvironment().getProperty("interceptor.resourceHandler");
        if (!StringUtil.isEmpty((String)resourceHandler)) {
            String[] handler = StringUtil.stringToArray((String)resourceHandler, (String)",");
            ResourceHandlerRegistration resourceHandlerRegistration = registry.addResourceHandler(handler);
            String resourceLocation = SpringUtil.getEnvironment().getProperty("interceptor.resourceLocation");
            if (resourceHandlerRegistration != null && !StringUtil.isEmpty((String)resourceLocation)) {
                String[] location = StringUtil.stringToArray((String)resourceLocation, (String)",");
                resourceHandlerRegistration.addResourceLocations(location);
            }
        }
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        super.configureMessageConverters(converters);
        List<HttpMessageConverter<?>> httpMessageConverters = SpringApplicationBuilder.getInstance().getHttpMessageConverters();
        if (httpMessageConverters != null) {
            converters.addAll(httpMessageConverters);
        }
    }
}

