/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.request;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ParameterXssWrapper
extends HttpServletRequestWrapper {
    private final Map<String, String[]> parameters;
    private final HttpServletRequest request;

    ParameterXssWrapper(HttpServletRequest request) {
        super(request);
        this.request = request;
        this.parameters = ParameterXssWrapper.doXss(request.getParameterMap(), true);
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public Enumeration<String> getParameterNames() {
        return new Vector<String>(this.parameters.keySet()).elements();
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public static Map<String, String[]> doXss(Map<String, String[]> map, boolean utf8) {
        Objects.requireNonNull(map);
        Iterator<Map.Entry<String, String[]>> iterator = map.entrySet().iterator();
        HashMap<String, String[]> valuesMap = new HashMap<String, String[]>();
        while (iterator.hasNext()) {
            Map.Entry<String, String[]> entry = iterator.next();
            String key = entry.getKey();
            String[] values = entry.getValue();
            if (values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                if (!utf8) {
                    values[i] = ParameterXssWrapper.getUTF8(values[i]);
                }
                values[i] = StringUtil.filterHTML((String)values[i]);
            }
            valuesMap.put(key, values);
        }
        return valuesMap;
    }

    public static String getUTF8(String str) {
        if (StringUtil.isEmpty((String)str)) {
            return "";
        }
        try {
            return new String(str.getBytes("ISO-8859-1"), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            DefaultSystemLog.ERROR().error("iso-8859-1 to utf-8 \u5931\u8d25", (Throwable)e);
            return "";
        }
    }
}

