/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.controller.base;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.SystemClock;
import cn.jiangzeyin.common.request.ParameterXssWrapper;
import cn.jiangzeyin.controller.base.AbstractBaseControl;
import cn.jiangzeyin.controller.multipart.MultipartFileConfig;
import cn.jiangzeyin.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public abstract class AbstractMultipartFileBaseControl
extends AbstractBaseControl {
    private static final ThreadLocal<Map<String, String[]>> MAP_THREAD_LOCAL_PARAMETER = new ThreadLocal();
    private static final ThreadLocal<MultipartHttpServletRequest> THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST = new ThreadLocal();

    protected Map<String, String[]> getParameter() {
        Map<String, String[]> map = MAP_THREAD_LOCAL_PARAMETER.get();
        if (map == null) {
            try {
                map = ParameterXssWrapper.doXss(this.getMultiRequest().getParameterMap(), false);
                MAP_THREAD_LOCAL_PARAMETER.set(map);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return map;
    }

    protected MultipartHttpServletRequest getMultiRequest() {
        HttpServletRequest request;
        MultipartHttpServletRequest multipartHttpServletRequest = THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.get();
        if (multipartHttpServletRequest == null && (request = super.getRequest()) instanceof MultipartHttpServletRequest) {
            multipartHttpServletRequest = (MultipartHttpServletRequest)request;
            THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.set(multipartHttpServletRequest);
        }
        Assert.notNull((Object)multipartHttpServletRequest, (String)"not is Multipart");
        return multipartHttpServletRequest;
    }

    @Override
    public void setReqAndRes(HttpServletRequest request, HttpSession session, HttpServletResponse response) {
        super.setReqAndRes(request, session, response);
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.set((MultipartHttpServletRequest)request);
            MAP_THREAD_LOCAL_PARAMETER.set(ParameterXssWrapper.doXss(this.getMultiRequest().getParameterMap(), false));
        } else {
            THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.set(null);
            MAP_THREAD_LOCAL_PARAMETER.set(null);
        }
    }

    @Override
    protected HttpServletRequest getRequest() {
        MultipartHttpServletRequest request;
        try {
            request = this.getMultiRequest();
        }
        catch (Exception e) {
            return super.getRequest();
        }
        return request;
    }

    protected MultipartFile getFile(String name) {
        return this.getMultiRequest().getFile(name);
    }

    protected List<MultipartFile> getFiles(String name) {
        return this.getMultiRequest().getFiles(name);
    }

    @Override
    protected <T> T getObject(Class<T> tClass) throws IllegalAccessException, InstantiationException {
        Map<String, String[]> parameter = this.getParameter();
        if (parameter == null) {
            return super.getObject(tClass);
        }
        T object = tClass.newInstance();
        this.doParameterMap(parameter, object);
        return object;
    }

    protected String upload(String name) throws IOException {
        return this.upload(new String[]{name})[0];
    }

    protected String[] upload(String ... name) throws IOException {
        Objects.requireNonNull(name);
        String[] path = new String[name.length];
        int len = path.length;
        for (int i = 0; i < len; ++i) {
            String fileName;
            String item = name[i];
            String localPath = MultipartFileConfig.getFileTempPath();
            MultipartFile multiFile = this.getFile(item);
            if (multiFile == null || (fileName = multiFile.getOriginalFilename()) == null || fileName.length() <= 0) continue;
            String filePath = StringUtil.clearPath((String)String.format("%s/%s_%s", localPath, SystemClock.now(), fileName));
            FileUtil.writeInputStream(multiFile.getInputStream(), new File(filePath));
            path[i] = filePath;
        }
        return path;
    }

    @Override
    protected String[] getParameters(String name) {
        Map<String, String[]> parameter = this.getParameter();
        if (parameter == null) {
            return super.getParameters(name);
        }
        return parameter.get(name);
    }

    @Override
    protected String getParameter(String name) {
        String[] values = this.getParameters(name);
        return values == null ? null : values[0];
    }

    @Override
    protected String getParameter(String name, String def) {
        String value = this.getParameter(name);
        return value == null ? def : value;
    }

    @Override
    protected int getParameterInt(String name) {
        return this.getParameterInt(name, 0);
    }

    @Override
    protected int getParameterInt(String name, int def) {
        String value = this.getParameter(name);
        return StringUtil.parseInt((String)value, (int)def);
    }
}

