/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common;

import cn.jiangzeyin.common.interceptor.BaseInterceptor;
import cn.jiangzeyin.common.spring.event.ApplicationEventClient;
import cn.jiangzeyin.common.spring.event.ApplicationEventLoad;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.StringUtils;

public class SpringApplicationBuilder
extends org.springframework.boot.builder.SpringApplicationBuilder {
    private static volatile SpringApplicationBuilder applicationBuilder;
    private Class applicationClass;
    private Environment environment;
    private List<ApplicationEventClient> applicationEventClients;
    private List<ApplicationEventLoad> applicationEventLoads;
    private List<Class<? extends BaseInterceptor>> interceptorClass;
    private List<HttpMessageConverter<?>> httpMessageConverters;

    public static SpringApplicationBuilder createBuilder(Object ... sources) throws Exception {
        return new SpringApplicationBuilder(sources);
    }

    protected SpringApplicationBuilder(Object ... sources) throws Exception {
        super(sources);
        if (applicationBuilder != null && !SpringApplicationBuilder.isRestart()) {
            throw new IllegalArgumentException("duplicate create");
        }
        if (sources == null || sources.length <= 0) {
            throw new IllegalArgumentException("please set sources");
        }
        Object object = sources[0];
        if (!(object instanceof Class)) {
            throw new IllegalArgumentException("sources index 0  must with class");
        }
        this.applicationClass = (Class)object;
        this.banner((environment, sourceClass, out) -> {
            this.environment = environment;
            String msg = environment.getProperty("banner.msg", "boot Application starting");
            out.println(msg);
        });
        this.addLoadPage("cn.jiangzeyin");
        applicationBuilder = this;
    }

    public static SpringApplicationBuilder getInstance() {
        if (applicationBuilder == null) {
            throw new RuntimeException("Application not start");
        }
        return applicationBuilder;
    }

    public Environment getEnvironment() {
        if (this.environment == null) {
            throw new RuntimeException("Application not start");
        }
        return this.environment;
    }

    public List<ApplicationEventClient> getApplicationEventClients() {
        return this.applicationEventClients;
    }

    public List<ApplicationEventLoad> getApplicationEventLoads() {
        return this.applicationEventLoads;
    }

    public List<Class<? extends BaseInterceptor>> getInterceptorClass() {
        return this.interceptorClass;
    }

    public List<HttpMessageConverter<?>> getHttpMessageConverters() {
        return this.httpMessageConverters;
    }

    public SpringApplicationBuilder addHttpMessageConverter(HttpMessageConverter<?> httpMessageConverter) {
        Objects.requireNonNull(httpMessageConverter);
        if (this.httpMessageConverters == null) {
            this.httpMessageConverters = new ArrayList();
        }
        this.httpMessageConverters.add(httpMessageConverter);
        return this;
    }

    public SpringApplicationBuilder addInterceptor(Class<? extends BaseInterceptor> cls) {
        Objects.requireNonNull(cls);
        if (this.interceptorClass == null) {
            this.interceptorClass = new ArrayList<Class<? extends BaseInterceptor>>();
        }
        this.interceptorClass.add(cls);
        return this;
    }

    public SpringApplicationBuilder addApplicationEventLoad(ApplicationEventLoad applicationEventLoad) {
        Objects.requireNonNull(applicationEventLoad);
        if (this.applicationEventLoads == null) {
            this.applicationEventLoads = new ArrayList<ApplicationEventLoad>();
        }
        this.applicationEventLoads.add(applicationEventLoad);
        return this;
    }

    public SpringApplicationBuilder addApplicationEventClient(ApplicationEventClient applicationEventClient) {
        Objects.requireNonNull(applicationEventClient);
        if (this.applicationEventClients == null) {
            this.applicationEventClients = new ArrayList<ApplicationEventClient>();
        }
        this.applicationEventClients.add(applicationEventClient);
        return this;
    }

    public SpringApplicationBuilder addLoadPage(String packageName) throws NoSuchFieldException, IllegalAccessException {
        if (StringUtils.isEmpty((Object)packageName)) {
            throw new IllegalArgumentException("packageName");
        }
        ComponentScan componentScan = this.applicationClass.getAnnotation(ComponentScan.class);
        if (componentScan == null) {
            throw new RuntimeException("please add ComponentScan");
        }
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(componentScan);
        Field value = invocationHandler.getClass().getDeclaredField("memberValues");
        value.setAccessible(true);
        Map memberValues = (Map)value.get(invocationHandler);
        String[] values = (String[])memberValues.get("value");
        String[] newValues = new String[]{packageName};
        newValues = StringUtils.mergeStringArrays((String[])values, (String[])newValues);
        memberValues.put("value", newValues);
        return this;
    }

    public static boolean isRestart() {
        String name = Thread.currentThread().getName();
        return "restartedMain".equalsIgnoreCase(name);
    }
}

