/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.interceptor;

import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.interceptor.CallbackController;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.http.HttpStatus;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public abstract class BaseInterceptor
extends HandlerInterceptorAdapter {
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    protected HttpSession session;
    protected ServletContext application;
    protected String url;
    private CallbackController callbackController;
    private static final ThreadLocal<HttpSession> HTTP_SESSION_THREAD_LOCAL = new ThreadLocal();

    public static HttpSession getSession() {
        return HTTP_SESSION_THREAD_LOCAL.get();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        HandlerMethod handlerMethod;
        Object object;
        Class<?> controlClass;
        this.request = request;
        this.response = response;
        this.session = request.getSession();
        this.application = this.session.getServletContext();
        HTTP_SESSION_THREAD_LOCAL.set(this.session);
        this.url = request.getRequestURI();
        if (handler instanceof HandlerMethod && CallbackController.class.isAssignableFrom(controlClass = (object = (handlerMethod = (HandlerMethod)handler).getBean()).getClass())) {
            this.callbackController = (CallbackController)object;
        }
        return true;
    }

    protected void reload() {
        if (this.callbackController != null) {
            this.callbackController.resetInfo();
        }
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (response.getStatus() != HttpStatus.OK.value()) {
            DefaultSystemLog.LOG().info("\u8bf7\u6c42\u9519\u8bef:" + request.getRequestURI() + "  " + response.getStatus());
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        if (ex != null) {
            DefaultSystemLog.ERROR().error("controller \u5f02\u5e38:" + request.getRequestURL(), (Throwable)ex);
        }
    }
}

