/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.controller.base;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.SystemClock;
import cn.jiangzeyin.common.request.ParameterXssWrapper;
import cn.jiangzeyin.controller.base.AbstractBaseControl;
import cn.jiangzeyin.controller.multipart.MultipartFileConfig;
import cn.jiangzeyin.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.tomcat.util.http.fileupload.servlet.ServletFileUpload;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

public abstract class AbstractMultipartFileBaseControl
extends AbstractBaseControl {
    private static final ThreadLocal<MultipartHttpServletRequest> THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST = new ThreadLocal();

    protected MultipartHttpServletRequest getMultiRequest() {
        HttpServletRequest request = this.getRequest();
        if (request instanceof MultipartHttpServletRequest) {
            return (MultipartHttpServletRequest)request;
        }
        throw new IllegalArgumentException("not MultipartHttpServletRequest");
    }

    @Override
    public void resetInfo() {
        super.resetInfo();
        THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.set(null);
    }

    @Override
    protected HttpServletRequest getRequest() {
        HttpServletRequest request = super.getRequest();
        if (ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            MultipartHttpServletRequest multipartHttpServletRequest = THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.get();
            if (multipartHttpServletRequest != null) {
                return multipartHttpServletRequest;
            }
            multipartHttpServletRequest = new StandardMultipartHttpServletRequest(request);
            THREAD_LOCAL_MULTIPART_HTTP_SERVLET_REQUEST.set(multipartHttpServletRequest);
            request = multipartHttpServletRequest;
        }
        return request;
    }

    protected MultipartFile getFile(String name) {
        return this.getMultiRequest().getFile(name);
    }

    protected List<MultipartFile> getFiles(String name) {
        return this.getMultiRequest().getFiles(name);
    }

    @Override
    protected <T> T getObject(Class<T> tClass) throws IllegalAccessException, InstantiationException {
        Map<String, String[]> parameter = this.getParameter();
        if (parameter == null) {
            return super.getObject(tClass);
        }
        T object = tClass.newInstance();
        this.doParameterMap(parameter, object);
        return object;
    }

    protected String upload(String name) throws IOException {
        return this.upload(new String[]{name})[0];
    }

    protected String[] upload(String ... name) throws IOException {
        Objects.requireNonNull(name);
        String[] path = new String[name.length];
        String localPath = MultipartFileConfig.getFileTempPath();
        int len = path.length;
        for (int i = 0; i < len; ++i) {
            String fileName;
            String item = name[i];
            MultipartFile multiFile = this.getFile(item);
            if (multiFile == null || (fileName = multiFile.getOriginalFilename()) == null || fileName.length() <= 0) continue;
            String filePath = StringUtil.clearPath((String)String.format("%s/%s_%s", localPath, SystemClock.now(), fileName));
            File file = new File(filePath);
            FileUtil.writeInputStream(multiFile.getInputStream(), file);
            path[i] = filePath;
        }
        return path;
    }

    private Map<String, String[]> getParameter() {
        Map<String, String[]> map = this.getRequest().getParameterMap();
        boolean doXss = Boolean.valueOf(String.valueOf(this.getAttribute("ParameterXssWrapper.doXss")));
        if (!doXss) {
            map = ParameterXssWrapper.doXss(map, false);
            this.setAttribute("ParameterXssWrapper.doXss", true);
        }
        return map;
    }

    @Override
    protected String[] getParameters(String name) {
        Map<String, String[]> parameter = this.getParameter();
        if (parameter == null) {
            return super.getParameters(name);
        }
        return parameter.get(name);
    }

    @Override
    protected String getParameter(String name) {
        String[] values = this.getParameters(name);
        return values == null ? null : values[0];
    }

    @Override
    protected String getParameter(String name, String def) {
        String value = this.getParameter(name);
        return value == null ? def : value;
    }

    @Override
    protected int getParameterInt(String name) {
        return this.getParameterInt(name, 0);
    }

    @Override
    protected int getParameterInt(String name, int def) {
        String value = this.getParameter(name);
        return StringUtil.parseInt((String)value, (int)def);
    }

    @Override
    protected long getParameterLong(String name) {
        return this.getParameterLong(name, 0L);
    }

    @Override
    protected long getParameterLong(String name, long def) {
        String value = this.getParameter(name);
        if (value == null) {
            return def;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }
}

