/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;

public final class FileUtil {
    public static int EACH_LEN = 0x100000;

    public static InputStream copyInputStream(InputStream input) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int len = input.available();
        int byteLen = len > EACH_LEN ? EACH_LEN : len;
        byte[] bytes = new byte[byteLen];
        while ((len = input.read(bytes)) > -1) {
            byteArrayOutputStream.write(bytes, 0, len);
        }
        byteArrayOutputStream.flush();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String inputStreamToString(InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream);
        StringBuilder sb = new StringBuilder();
        InputStreamReader inputStreamReader = null;
        BufferedReader br = null;
        try {
            String line;
            inputStreamReader = new InputStreamReader(inputStream);
            br = new BufferedReader(inputStreamReader);
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            inputStream.close();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeInputStream(InputStream inputStream, File file) throws IOException {
        Objects.requireNonNull(inputStream, "inputStream is null");
        Objects.requireNonNull(file, "file is null");
        File parent = file.getParentFile();
        if (!parent.exists() && !parent.mkdirs()) {
            throw new IllegalArgumentException(file.getPath() + " create fail");
        }
        FilterOutputStream outputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            int byteCount;
            fileOutputStream = new FileOutputStream(file);
            outputStream = new DataOutputStream(fileOutputStream);
            int len = inputStream.available();
            int byteLen = len > EACH_LEN ? EACH_LEN : len;
            byte[] bytes = new byte[byteLen];
            while ((byteCount = inputStream.read(bytes)) != -1) {
                ((DataOutputStream)outputStream).write(bytes, 0, byteCount);
            }
        }
        finally {
            inputStream.close();
            if (outputStream != null) {
                outputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
    }
}

