/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.interceptor;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.interceptor.BaseInterceptor;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class CallbackController {
    public void resetInfo() {
    }

    public static ServletRequestAttributes getRequestAttributes() {
        RequestAttributes attributes = null;
        try {
            attributes = RequestContextHolder.currentRequestAttributes();
        }
        catch (IllegalStateException e) {
            DefaultSystemLog.ERROR().error("\u83b7\u53d6req\u5931\u8d25", (Throwable)e);
        }
        Objects.requireNonNull(attributes);
        if (attributes instanceof ServletRequestAttributes) {
            return (ServletRequestAttributes)attributes;
        }
        throw new IllegalArgumentException("error");
    }

    public HttpServletResponse getResponse() {
        HttpServletResponse response = CallbackController.getRequestAttributes().getResponse();
        Objects.requireNonNull(response, "response null");
        return response;
    }

    public HttpSession getSession() {
        HttpSession session = CallbackController.getRequestAttributes().getRequest().getSession();
        if (session == null) {
            session = BaseInterceptor.getSession();
        }
        Objects.requireNonNull(session, "session null");
        return session;
    }

    public HttpServletRequest getRequest() {
        HttpServletRequest request = CallbackController.getRequestAttributes().getRequest();
        Objects.requireNonNull(request, "request null");
        return request;
    }

    public Object getAttribute(String name) {
        return CallbackController.getRequestAttributes().getAttribute(name, 0);
    }

    public void setAttribute(String name, Object object) {
        CallbackController.getRequestAttributes().setAttribute(name, object, 0);
    }

    public String getSessionAttribute(String name) {
        return StringUtil.convertNULL((Object)this.getSessionAttributeObj(name));
    }

    public Object getSessionAttributeObj(String name) {
        return CallbackController.getRequestAttributes().getAttribute(name, 1);
    }

    public void removeSessionAttribute(String name) {
        CallbackController.getRequestAttributes().removeAttribute(name, 1);
    }

    public void setSessionAttribute(String name, Object object) {
        CallbackController.getRequestAttributes().setAttribute(name, object, 1);
    }
}

