/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.spring;

import cn.jiangzeyin.common.request.XssFilter;
import cn.jiangzeyin.common.spring.SpringUtil;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.context.embedded.EmbeddedServletContainerCustomizer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TomcatInitBean {
    @Bean
    public EmbeddedServletContainerCustomizer containerCustomizer() {
        return container -> {
            Integer timOut = (Integer)SpringUtil.getEnvironment().getProperty("tomcat.sessionTimeOut", Integer.class);
            if (timOut != null) {
                container.setSessionTimeout(timOut.intValue(), TimeUnit.MINUTES);
            }
        };
    }

    @Bean
    public ServletContextInitializer servletContextInitializer() {
        return servletContext -> {
            String name = SpringUtil.getEnvironment().getProperty("tomcat.sessionCookieName");
            if (name != null && name.length() > 0) {
                servletContext.getSessionCookieConfig().setName(name);
            }
        };
    }

    @Bean
    public XssFilter characterEncodingFilter() {
        XssFilter characterEncodingFilter = new XssFilter();
        characterEncodingFilter.setEncoding("UTF-8");
        characterEncodingFilter.setForceEncoding(true);
        return characterEncodingFilter;
    }
}

