/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.PreLoadClass;
import cn.jiangzeyin.common.PreLoadMethod;
import cn.jiangzeyin.common.SpringApplicationBuilder;
import cn.jiangzeyin.common.spring.SpringUtil;
import cn.jiangzeyin.util.PackageUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CommonInitPackage {
    private static volatile boolean init = false;
    private static final List<Method> METHOD_LIST = new ArrayList<Method>();
    private static final List<String> PACKAGE_NAME_LIST = new ArrayList<String>();

    public static void init() {
        if (init && !SpringApplicationBuilder.isRestart()) {
            DefaultSystemLog.LOG().info("\u7cfb\u7edfinit \u5305\u5df2\u7ecf\u88ab\u521d\u59cb\u5316\u8fc7\u5566\uff01");
            return;
        }
        String pageName = SpringUtil.getEnvironment().getProperty("preload.packageName");
        if (StringUtil.isEmpty((String)pageName)) {
            return;
        }
        CommonInitPackage.load(pageName);
        init = true;
    }

    public static void load(String packageName) {
        if (PACKAGE_NAME_LIST.contains(packageName) && !SpringApplicationBuilder.isRestart()) {
            DefaultSystemLog.LOG().info(packageName + " \u5305\u5df2\u7ecf\u88ab\u521d\u59cb\u5316\u8fc7\u5566\uff01");
            return;
        }
        try {
            List<String> list = PackageUtil.getClassName(packageName);
            if (list == null || list.size() <= 0) {
                return;
            }
            ArrayList classList = new ArrayList();
            for (String name : list) {
                try {
                    Class<?> cls = Class.forName(name);
                    classList.add(cls);
                }
                catch (ClassNotFoundException e) {
                    DefaultSystemLog.ERROR().error("\u9884\u52a0\u8f7d\u5305\u9519\u8bef:" + name, (Throwable)e);
                }
            }
            if (classList.size() <= 0) {
                return;
            }
            List<Map.Entry<Class, Integer>> newList = CommonInitPackage.splitClass(classList);
            if (newList != null) {
                for (Map.Entry<Class, Integer> item : newList) {
                    CommonInitPackage.loadClass(item.getKey());
                }
            }
            PACKAGE_NAME_LIST.add(packageName);
        }
        catch (IOException e) {
            DefaultSystemLog.ERROR().error("\u9884\u52a0\u8f7d\u5305\u9519\u8bef", (Throwable)e);
        }
    }

    private static List<Map.Entry<Class, Integer>> splitClass(List<Class<?>> list) {
        HashMap sortMap = new HashMap();
        for (Class<?> item : list) {
            PreLoadClass preLoadClass = item.getAnnotation(PreLoadClass.class);
            if (preLoadClass == null) continue;
            sortMap.put(item, preLoadClass.value());
        }
        ArrayList newList = null;
        if (sortMap.size() > 0) {
            newList = new ArrayList(sortMap.entrySet());
            newList.sort(Comparator.comparing(Map.Entry::getValue));
        }
        return newList;
    }

    /*
     * WARNING - void declaration
     */
    private static void loadClass(Class classT) {
        Method method;
        void var5_7;
        SpringUtil.registerSingleton(classT);
        Method[] methods = classT.getDeclaredMethods();
        HashMap<Method, Integer> sortMap = new HashMap<Method, Integer>();
        Method[] methodArray = methods;
        int n = methodArray.length;
        boolean bl = false;
        while (var5_7 < n) {
            method = methodArray[var5_7];
            PreLoadMethod preLoadMethod = method.getAnnotation(PreLoadMethod.class);
            if (preLoadMethod != null) {
                Type type = method.getGenericReturnType();
                int modifiers = method.getModifiers();
                Class<?>[] parameters = method.getParameterTypes();
                if (parameters.length <= 0 && Void.TYPE.equals(type) && Modifier.isStatic(modifiers) && Modifier.isPrivate(modifiers)) {
                    sortMap.put(method, preLoadMethod.value());
                } else {
                    throw new IllegalArgumentException(classT + "  " + method + "  " + PreLoadMethod.class + " must use empty parameters static void private");
                }
            }
            ++var5_7;
        }
        if (sortMap.size() > 0) {
            ArrayList newList = new ArrayList(sortMap.entrySet());
            newList.sort(Comparator.comparing(Map.Entry::getValue));
            for (Map.Entry entry : newList) {
                method = (Method)entry.getKey();
                if (METHOD_LIST.contains(method) && !SpringApplicationBuilder.isRestart()) {
                    DefaultSystemLog.LOG().info(classT + "  " + method.getName() + "\u5df2\u7ecf\u8c03\u7528\u8fc7\u5566");
                    continue;
                }
                try {
                    method.setAccessible(true);
                    method.invoke(null, new Object[0]);
                    METHOD_LIST.add(method);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    DefaultSystemLog.ERROR().error("\u9884\u52a0\u8f7d\u5305\u9519\u8bef:" + classT + "  " + method.getName() + "  \u6267\u884c\u9519\u8bef", (Throwable)e);
                }
            }
        }
    }
}

