/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedRollingPolicy;
import ch.qos.logback.core.util.FileSize;
import cn.jiangzeyin.common.spring.SpringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.LoggerFactory;

public class DefaultSystemLog {
    private static final LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
    private static final Map<LogType, Logger> LOG_TYPE_LOGGER_MAP = new ConcurrentHashMap<LogType, Logger>();
    private static final String TYPE_ERROR_TAG = "ERROR";
    private static ConsoleAppender<ILoggingEvent> consoleAppender;

    public static void init() {
        consoleAppender = DefaultSystemLog.initConsole();
        DefaultSystemLog.initSystemLog();
    }

    private static void initSystemLog() {
        for (LogType type : LogType.values()) {
            String tag = type.toString();
            Level level = Level.INFO;
            if (tag.endsWith(TYPE_ERROR_TAG)) {
                level = Level.ERROR;
            }
            Logger logger = DefaultSystemLog.initLogger(tag, tag, level);
            LOG_TYPE_LOGGER_MAP.put(type, logger);
        }
    }

    private static ConsoleAppender<ILoggingEvent> initConsole() {
        ConsoleAppender appender = new ConsoleAppender();
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setContext((Context)loggerContext);
        patternLayout.setPattern("%date %level [%thread] %logger{10} [%file:%line]- x:\\(%X\\) %msg%n");
        patternLayout.start();
        appender.setLayout((Layout)patternLayout);
        appender.setContext((Context)loggerContext);
        appender.start();
        return appender;
    }

    private static Logger initLogger(String tag, String path, Level level) {
        Logger logger = (Logger)LoggerFactory.getLogger((String)tag);
        logger.detachAndStopAllAppenders();
        logger.setLevel(level);
        AsyncAppender asyncAppender = new AsyncAppender();
        asyncAppender.setDiscardingThreshold(0);
        asyncAppender.setQueueSize(512);
        RollingFileAppender appender = new RollingFileAppender();
        SizeAndTimeBasedRollingPolicy policy = new SizeAndTimeBasedRollingPolicy();
        policy.setContext((Context)loggerContext);
        String logPath = "/log/cn.jiangzeyin";
        String filePath = String.format("%s/%s/%s/%s", logPath, SpringUtil.getApplicationId(), path, tag).toLowerCase();
        policy.setFileNamePattern(String.format("%s-%%d{yyyy-MM-dd}.%%event.log", filePath));
        policy.setMaxFileSize(FileSize.valueOf((String)"100MB"));
        policy.setMaxHistory(30);
        policy.setTotalSizeCap(FileSize.valueOf((String)"10GB"));
        policy.setParent((FileAppender)appender);
        policy.start();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)loggerContext);
        encoder.setPattern("%d{HH:mm:ss.SSS} %-5level [%thread %file:%line] %logger - %msg%n");
        encoder.start();
        appender.setFile(String.format("%s.log", filePath));
        appender.setName("appender" + tag);
        appender.setRollingPolicy((RollingPolicy)policy);
        appender.setContext((Context)loggerContext);
        appender.setEncoder((Encoder)encoder);
        appender.setPrudent(true);
        appender.start();
        asyncAppender.addAppender((Appender)appender);
        asyncAppender.start();
        logger.addAppender((Appender)asyncAppender);
        if (level == Level.ERROR) {
            logger.addAppender(consoleAppender);
        }
        logger.setAdditive(true);
        return logger;
    }

    public static Logger LOG(LogType type) {
        Logger logger = LOG_TYPE_LOGGER_MAP.get((Object)type);
        if (logger == null && LogType.DEFAULT != type) {
            logger = DefaultSystemLog.LOG(LogType.DEFAULT);
        }
        if (logger == null) {
            throw new IllegalArgumentException("not find");
        }
        return logger;
    }

    public static Logger LOG() {
        return DefaultSystemLog.LOG(LogType.DEFAULT);
    }

    public static Logger ERROR() {
        return DefaultSystemLog.LOG(LogType.ERROR);
    }

    public static enum LogType {
        REQUEST,
        REQUEST_ERROR,
        DEFAULT,
        ERROR;

    }
}

