/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.cache;

import cn.jiangzeyin.DateUtil;
import cn.jiangzeyin.cache.CacheInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ObjectCache {
    private static final ConcurrentHashMap<String, CacheEntity<String, Object>> CONCURRENT_HASH_MAP = new ConcurrentHashMap(100);
    private static final ConcurrentHashMap<String, CacheInfo> CACHE_INFO_CONCURRENT_HASH_MAP = new ConcurrentHashMap(100);
    static final int DEFAULT_CACHE_TIME = 600;

    private ObjectCache() {
    }

    public static void config(Class cls) throws IllegalAccessException {
        CACHE_INFO_CONCURRENT_HASH_MAP.putAll(CacheInfo.loadClass(cls));
    }

    public static Object put(String key, Object value) {
        return ObjectCache.put(key, value, 600L);
    }

    public static Object put(String key, Object value, long cacheTime) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            throw new NullPointerException();
        }
        if (cacheTime <= 0L) {
            throw new IllegalArgumentException("cacheTime must >0");
        }
        AtomicBoolean containsKey = new AtomicBoolean(true);
        CacheEntity cacheEntity = CONCURRENT_HASH_MAP.computeIfAbsent(key, entityKey -> {
            CacheInfo cacheInfo = CACHE_INFO_CONCURRENT_HASH_MAP.computeIfAbsent(key, s -> new CacheInfo(key, cacheTime));
            if (cacheTime != cacheInfo.getCacheTime()) {
                cacheInfo.setCacheTime(cacheTime);
            }
            containsKey.set(false);
            return new CacheEntity<String, Object>(key, value, cacheInfo);
        });
        return containsKey.get() ? cacheEntity.setValue(value, cacheTime) : null;
    }

    public static Object get(String key) {
        if (key == null) {
            throw new NullPointerException();
        }
        CacheEntity<String, Object> cacheEntity = CONCURRENT_HASH_MAP.get(key);
        return cacheEntity == null ? null : cacheEntity.getValue();
    }

    private static long getCurrentTime() {
        return DateUtil.getCurrentShortTimeMillis();
    }

    private static class CacheEntity<K, V>
    implements Map.Entry<K, V> {
        final K key;
        final CacheInfo cacheInfo;
        V value;
        long intoTime;

        CacheEntity(K key, V value, CacheInfo cacheInfo) {
            this.key = key;
            this.value = value;
            this.intoTime = ObjectCache.getCurrentTime();
            this.cacheInfo = cacheInfo;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            long existTime = ObjectCache.getCurrentTime() - this.intoTime;
            if (existTime > this.cacheInfo.getCacheTime()) {
                return null;
            }
            return this.value;
        }

        @Override
        public V setValue(V value) {
            if (value == null) {
                throw new NullPointerException();
            }
            V val = this.value;
            this.value = value;
            this.intoTime = ObjectCache.getCurrentTime();
            return val;
        }

        V setValue(V value, long cacheTime) {
            if (cacheTime != -1L) {
                this.cacheInfo.setCacheTime(cacheTime);
            }
            return this.setValue(value);
        }
    }
}

