/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common;

import cn.jiangzeyin.common.AutoPropertiesClass;
import cn.jiangzeyin.common.AutoPropertiesMethod;
import cn.jiangzeyin.common.EnableCommonBoot;
import cn.jiangzeyin.common.PreLoadMethod;
import cn.jiangzeyin.common.interceptor.BaseInterceptor;
import cn.jiangzeyin.common.spring.event.ApplicationEventClient;
import cn.jiangzeyin.common.spring.event.ApplicationEventLoad;
import cn.jiangzeyin.util.PackageUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.core.env.Environment;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.StringUtils;

public class ApplicationBuilder
extends SpringApplicationBuilder {
    private static volatile ApplicationBuilder applicationBuilder;
    private Class applicationClass;
    private SpringApplication application = this.application();
    private Environment environment;
    private List<ApplicationEventClient> applicationEventClients;
    private List<ApplicationEventLoad> applicationEventLoads;
    private List<Class<? extends BaseInterceptor>> interceptorClass;
    private List<HttpMessageConverter<?>> httpMessageConverters;

    public static ApplicationBuilder createBuilder(Object ... sources) throws Exception {
        return new ApplicationBuilder(sources);
    }

    protected ApplicationBuilder(Object ... sources) throws Exception {
        super(sources);
        if (applicationBuilder != null && !ApplicationBuilder.isRestart()) {
            throw new IllegalArgumentException("duplicate create");
        }
        this.applicationClass = this.application.getMainApplicationClass();
        this.banner((environment, sourceClass, out) -> {
            this.environment = environment;
            String msg = environment.getProperty("banner.msg", "boot Application starting");
            out.println(msg);
        });
        EnableCommonBoot enableCommonBoot = this.applicationClass.getAnnotation(EnableCommonBoot.class);
        if (enableCommonBoot == null) {
            this.addLoadPage("cn.jiangzeyin");
        }
        applicationBuilder = this;
    }

    public static ApplicationBuilder getInstance() {
        if (applicationBuilder == null) {
            throw new RuntimeException("Application not start");
        }
        return applicationBuilder;
    }

    public Environment getEnvironment() {
        if (this.environment == null) {
            throw new RuntimeException("Application not start");
        }
        return this.environment;
    }

    public List<ApplicationEventClient> getApplicationEventClients() {
        return this.applicationEventClients;
    }

    public List<ApplicationEventLoad> getApplicationEventLoads() {
        return this.applicationEventLoads;
    }

    public List<Class<? extends BaseInterceptor>> getInterceptorClass() {
        return this.interceptorClass;
    }

    public List<HttpMessageConverter<?>> getHttpMessageConverters() {
        return this.httpMessageConverters;
    }

    public ApplicationBuilder addHttpMessageConverter(HttpMessageConverter<?> httpMessageConverter) {
        Objects.requireNonNull(httpMessageConverter);
        if (this.httpMessageConverters == null) {
            this.httpMessageConverters = new ArrayList();
        }
        this.httpMessageConverters.add(httpMessageConverter);
        return this;
    }

    public ApplicationBuilder addInterceptor(Class<? extends BaseInterceptor> cls) {
        Objects.requireNonNull(cls);
        if (this.interceptorClass == null) {
            this.interceptorClass = new ArrayList<Class<? extends BaseInterceptor>>();
        }
        this.interceptorClass.add(cls);
        return this;
    }

    public ApplicationBuilder addApplicationEventLoad(ApplicationEventLoad applicationEventLoad) {
        Objects.requireNonNull(applicationEventLoad);
        if (this.applicationEventLoads == null) {
            this.applicationEventLoads = new ArrayList<ApplicationEventLoad>();
        }
        this.applicationEventLoads.add(applicationEventLoad);
        return this;
    }

    public ApplicationBuilder addApplicationEventClient(ApplicationEventClient applicationEventClient) {
        Objects.requireNonNull(applicationEventClient);
        if (this.applicationEventClients == null) {
            this.applicationEventClients = new ArrayList<ApplicationEventClient>();
        }
        this.applicationEventClients.add(applicationEventClient);
        return this;
    }

    public ApplicationBuilder addLoadPage(String packageName) throws NoSuchFieldException, IllegalAccessException {
        if (StringUtils.isEmpty((Object)packageName)) {
            throw new IllegalArgumentException("packageName");
        }
        ComponentScan componentScan = this.applicationClass.getAnnotation(ComponentScan.class);
        if (componentScan == null) {
            new IllegalArgumentException("please add ComponentScan").printStackTrace();
            return this;
        }
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(componentScan);
        Field value = invocationHandler.getClass().getDeclaredField("memberValues");
        value.setAccessible(true);
        Map memberValues = (Map)value.get(invocationHandler);
        String[] values = (String[])memberValues.get("value");
        String[] newValues = new String[]{packageName};
        newValues = StringUtils.mergeStringArrays((String[])values, (String[])newValues);
        memberValues.put("value", newValues);
        return this;
    }

    public static boolean isRestart() {
        String name = Thread.currentThread().getName();
        return "restartedMain".equalsIgnoreCase(name);
    }

    public void loadProperties(String packageName) throws Exception {
        List<String> list = PackageUtil.getClassName(packageName, false);
        for (String item : list) {
            Method[] methods;
            Class<?> cls = Class.forName(item);
            AutoPropertiesClass autoPropertiesClass = cls.getAnnotation(AutoPropertiesClass.class);
            if (autoPropertiesClass == null || (methods = cls.getDeclaredMethods()) == null) continue;
            for (Method method : methods) {
                AutoPropertiesMethod autoPropertiesMethod = method.getAnnotation(AutoPropertiesMethod.class);
                if (autoPropertiesMethod == null) continue;
                method.setAccessible(true);
                ParameterizedType parameterizedType = (ParameterizedType)method.getGenericReturnType();
                Type type = parameterizedType.getRawType();
                Class retCls = (Class)type;
                int modifiers = method.getModifiers();
                Class<?>[] parameters = method.getParameterTypes();
                if (parameters.length <= 0 && Map.class == retCls && Modifier.isStatic(modifiers) && Modifier.isPrivate(modifiers)) {
                    Map map = (Map)method.invoke(null, new Object[0]);
                    if (map == null) continue;
                    this.properties(map);
                    continue;
                }
                throw new IllegalArgumentException(cls + "  " + method + "  " + PreLoadMethod.class + " must use empty parameters static Map private");
            }
        }
    }
}

