/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.interceptor;

import cn.jiangzeyin.StringUtil;
import cn.jiangzeyin.common.interceptor.BaseInterceptor;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class BaseCallbackController {
    public void resetInfo() {
    }

    public static ServletRequestAttributes getRequestAttributes() {
        ServletRequestAttributes servletRequestAttributes = BaseCallbackController.tryGetRequestAttributes();
        Objects.requireNonNull(servletRequestAttributes);
        return servletRequestAttributes;
    }

    public static ServletRequestAttributes tryGetRequestAttributes() {
        RequestAttributes attributes = null;
        try {
            attributes = RequestContextHolder.currentRequestAttributes();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (attributes == null) {
            return null;
        }
        if (attributes instanceof ServletRequestAttributes) {
            return (ServletRequestAttributes)attributes;
        }
        return null;
    }

    public HttpServletResponse getResponse() {
        HttpServletResponse response = BaseCallbackController.getRequestAttributes().getResponse();
        Objects.requireNonNull(response, "response null");
        return response;
    }

    public HttpSession getSession() {
        HttpSession session = BaseCallbackController.getRequestAttributes().getRequest().getSession();
        if (session == null) {
            session = BaseInterceptor.getSession();
        }
        Objects.requireNonNull(session, "session null");
        return session;
    }

    public HttpServletRequest getRequest() {
        HttpServletRequest request = BaseCallbackController.getRequestAttributes().getRequest();
        Objects.requireNonNull(request, "request null");
        return request;
    }

    public Object getAttribute(String name) {
        return BaseCallbackController.getRequestAttributes().getAttribute(name, 0);
    }

    public void setAttribute(String name, Object object) {
        BaseCallbackController.getRequestAttributes().setAttribute(name, object, 0);
    }

    public String getSessionAttribute(String name) {
        return StringUtil.convertNULL((Object)this.getSessionAttributeObj(name));
    }

    public Object getSessionAttributeObj(String name) {
        return BaseCallbackController.getRequestAttributes().getAttribute(name, 1);
    }

    public void removeSessionAttribute(String name) {
        BaseCallbackController.getRequestAttributes().removeAttribute(name, 1);
    }

    public void setSessionAttribute(String name, Object object) {
        BaseCallbackController.getRequestAttributes().setAttribute(name, object, 1);
    }
}

