/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.controller.base;

import cn.jiangzeyin.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public final class RequestUtil {
    public static Map<String, String> convertUrlMap(String url) throws UnsupportedEncodingException {
        if (StringUtil.isEmpty((String)url)) {
            return null;
        }
        HashMap<String, String> mapRequest = new HashMap<String, String>();
        String[] arrSplit = (url = url.trim().toLowerCase()).split("[?]");
        if (arrSplit.length <= 1) {
            return mapRequest;
        }
        String allParam = arrSplit[1];
        if (StringUtil.isEmpty((String)allParam)) {
            return mapRequest;
        }
        for (String strSplit : arrSplit = allParam.split("[&]")) {
            String[] arrSplitEqual = strSplit.split("[=]");
            if (arrSplitEqual.length > 1) {
                mapRequest.put(arrSplitEqual[0], URLDecoder.decode(arrSplitEqual[1], "UTF-8"));
                continue;
            }
            if ("".equals(arrSplitEqual[0])) continue;
            mapRequest.put(arrSplitEqual[0], "");
        }
        return mapRequest;
    }

    public static Cookie getCookieByName(HttpServletRequest request, String name) {
        Map<String, Cookie> cookieMap = RequestUtil.readCookieMap(request);
        return cookieMap.getOrDefault(name, null);
    }

    private static Map<String, Cookie> readCookieMap(HttpServletRequest request) {
        HashMap<String, Cookie> cookieMap = new HashMap<String, Cookie>();
        Cookie[] cookies = request.getCookies();
        if (null != cookies) {
            for (Cookie cookie : cookies) {
                cookieMap.put(cookie.getName(), cookie);
            }
        }
        return cookieMap;
    }

    public static Map<String, String> getHeaderMapValues(HttpServletRequest request) {
        Enumeration enumeration = request.getHeaderNames();
        HashMap<String, String> headerMapValues = new HashMap<String, String>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                headerMapValues.put(name, request.getHeader(name));
            }
        }
        return headerMapValues;
    }
}

