/*
 * Decompiled with CFR 0.152.
 */
package cn.jiangzeyin.common.interceptor;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ClassUtil;
import cn.hutool.core.util.StrUtil;
import cn.jiangzeyin.common.ApplicationBuilder;
import cn.jiangzeyin.common.DefaultSystemLog;
import cn.jiangzeyin.common.interceptor.BaseInterceptor;
import cn.jiangzeyin.common.interceptor.InterceptorPattens;
import cn.jiangzeyin.common.spring.SpringUtil;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableWebMvc
public class InterceptorControl
extends WebMvcConfigurerAdapter {
    @Value(value="${interceptor.initPackageName:}")
    private String loadPath;
    private static final List<Class> LOAD_OK = new ArrayList<Class>();
    private InterceptorRegistry registry;

    public void addInterceptors(InterceptorRegistry registry) {
        this.registry = registry;
        this.init();
    }

    private void init() {
        this.loadApplicationInterceptor();
        if (StrUtil.isNotEmpty((CharSequence)this.loadPath)) {
            Set classSet = ClassUtil.scanPackageByAnnotation((String)this.loadPath, InterceptorPattens.class);
            this.loadClass(classSet);
        }
    }

    private void loadApplicationInterceptor() {
        Set<Class<? extends BaseInterceptor>> interceptorClass = ApplicationBuilder.getInstance().getInterceptorClass();
        if (interceptorClass == null) {
            return;
        }
        Class[] cls = interceptorClass.toArray(new Class[0]);
        HashSet newSet = new HashSet(Arrays.asList(cls));
        this.loadClass(newSet);
    }

    private void loadClass(Set<Class<?>> set) {
        if (null == set) {
            return;
        }
        List<Map.Entry<Class, Integer>> newList = InterceptorControl.splitClass(set);
        if (newList != null) {
            for (Map.Entry<Class, Integer> entry : newList) {
                this.loadInterceptor(entry.getKey(), this.registry);
            }
        }
    }

    private static List<Map.Entry<Class, Integer>> splitClass(Set<Class<?>> list) {
        HashMap sortMap = new HashMap(10);
        for (Class<?> item : list) {
            boolean isAbstract = Modifier.isAbstract(item.getModifiers());
            if (isAbstract) continue;
            if (!BaseInterceptor.class.isAssignableFrom(item)) {
                DefaultSystemLog.LOG().info("\u52a0\u8f7d\u62e6\u622a\u5668\u5f02\u5e38: {} \u6ca1\u6709\u7ee7\u627f {}", item, BaseInterceptor.class);
                continue;
            }
            InterceptorPattens interceptorPattens = item.getAnnotation(InterceptorPattens.class);
            sortMap.put(item, interceptorPattens.sort());
        }
        ArrayList newList = null;
        if (sortMap.size() > 0) {
            newList = new ArrayList(sortMap.entrySet());
            newList.sort(Comparator.comparing(Map.Entry::getValue));
        }
        return newList;
    }

    private void loadInterceptor(Class itemCls, InterceptorRegistry registry) {
        BaseInterceptor handlerInterceptor;
        if (LOAD_OK.contains(itemCls) && !ApplicationBuilder.isRestart()) {
            DefaultSystemLog.LOG().info("\u91cd\u590d\u6ce8\u5165\u62e6\u622a\u5668" + itemCls);
            return;
        }
        InterceptorPattens interceptorPattens = itemCls.getAnnotation(InterceptorPattens.class);
        try {
            handlerInterceptor = (BaseInterceptor)((Object)itemCls.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            DefaultSystemLog.ERROR().error("\u52a0\u8f7d\u62e6\u622a\u5668\u9519\u8bef", (Throwable)e);
            return;
        }
        Object[] patterns = interceptorPattens.value();
        InterceptorRegistration registration = registry.addInterceptor((HandlerInterceptor)handlerInterceptor);
        registration.addPathPatterns((String[])patterns);
        Object[] exclude = interceptorPattens.exclude();
        if (exclude.length > 0) {
            registration.excludePathPatterns((String[])exclude);
        }
        LOAD_OK.add(itemCls);
        DefaultSystemLog.LOG().info("\u52a0\u8f7d\u62e6\u622a\u5668\uff1a{} {} {} {}", new Object[]{itemCls, Arrays.toString(patterns), Arrays.toString(exclude), interceptorPattens.sort()});
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        String resourceHandler = SpringUtil.getEnvironment().getProperty("interceptor.resourceHandler");
        if (StrUtil.isNotBlank((CharSequence)resourceHandler)) {
            String[] handler = (String[])ArrayUtil.toArray((Collection)StrUtil.splitTrim((CharSequence)resourceHandler, (CharSequence)","), String.class);
            ResourceHandlerRegistration resourceHandlerRegistration = registry.addResourceHandler(handler);
            String resourceLocation = SpringUtil.getEnvironment().getProperty("interceptor.resourceLocation");
            if (resourceHandlerRegistration != null && StrUtil.isNotBlank((CharSequence)resourceLocation)) {
                String[] location = (String[])ArrayUtil.toArray((Collection)StrUtil.splitTrim((CharSequence)resourceLocation, (CharSequence)","), String.class);
                resourceHandlerRegistration.addResourceLocations(location);
            }
        }
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        super.configureMessageConverters(converters);
        Set<HttpMessageConverter<?>> httpMessageConverters = ApplicationBuilder.getInstance().getHttpMessageConverters();
        if (httpMessageConverters != null) {
            converters.addAll(httpMessageConverters);
        }
    }
}

